/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.rice.kew.notes.service.impl;

import co.kuali.rice.coreservice.api.attachment.S3FileService;
import co.kuali.rice.kew.notes.service.impl.RiceAttachmentDataToS3Conversion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.quartz.DisallowConcurrentExecution;

@DisallowConcurrentExecution
public class RiceAttachmentDataToS3ConversionImpl
implements RiceAttachmentDataToS3Conversion {
    private static final Logger LOG = LogManager.getLogger(RiceAttachmentDataToS3ConversionImpl.class);
    private static final String DELETE_FILE_FROM_FILESYSTEM = "DELETE_FILE_FROM_FILESYSTEM";
    private S3FileService riceS3FileService;
    private ParameterService parameterService;
    private DataObjectService dataObjectService;

    @Override
    public void execute() {
        LOG.info("Starting attachment conversion job for file_data to S3");
        if (!this.processRecords()) {
            return;
        }
        List attachments = this.dataObjectService.findMatching(Attachment.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.isNotNull((String)"fileLoc")})).getResults();
        attachments.forEach(attachment -> {
            block13: {
                try {
                    String dbMD5;
                    byte[] s3Bytes;
                    Object s3File;
                    File file = new File(attachment.getFileLoc());
                    if (!file.isFile() || !file.exists()) break block13;
                    byte[] fsBytes = FileUtils.readFileToByteArray((File)file);
                    String fileDataId = attachment.getFileDataId();
                    if (StringUtils.isBlank((CharSequence)fileDataId)) {
                        fileDataId = UUID.randomUUID().toString();
                        s3File = null;
                    } else {
                        s3File = this.riceS3FileService.retrieveFile(fileDataId);
                    }
                    if (s3File == null) {
                        Class<?> s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
                        Object newS3File = s3FileClass.newInstance();
                        Method setId = s3FileClass.getMethod("setId", String.class);
                        setId.invoke(newS3File, fileDataId);
                        Method setFileContents = s3FileClass.getMethod("setByteContents", byte[].class);
                        setFileContents.invoke(newS3File, new Object[]{fsBytes});
                        this.riceS3FileService.createFile(newS3File);
                        s3Bytes = this.getBytesFromS3File(this.riceS3FileService.retrieveFile(fileDataId));
                    } else {
                        if (LOG.isDebugEnabled()) {
                            Method getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                            LOG.debug("data found in S3, existing id: " + fileDataId + " attachment id " + attachment.getAttachmentId() + " metadata: " + getFileMetaData.invoke(s3File, new Object[0]));
                        }
                        s3Bytes = this.getBytesFromS3File(s3File);
                    }
                    if (s3Bytes == null || fsBytes == null) break block13;
                    String s3MD5 = DigestUtils.md5Hex((byte[])s3Bytes);
                    if (!Objects.equals(s3MD5, dbMD5 = DigestUtils.md5Hex((byte[])fsBytes))) {
                        LOG.error("S3 data MD5: " + s3MD5 + " does not equal DB data MD5: " + dbMD5 + " for id: " + fileDataId + " attachment id " + attachment.getAttachmentId());
                        break block13;
                    }
                    attachment.setFileDataId(fileDataId);
                    if (this.isDeleteFromFileSystem()) {
                        attachment.setFileLoc(null);
                    }
                    try {
                        this.dataObjectService.save(attachment, new PersistenceOption[]{PersistenceOption.FLUSH});
                    }
                    finally {
                        if (this.isDeleteFromFileSystem()) {
                            file.delete();
                        }
                    }
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        LOG.info("Finishing attachment conversion job for file_data to S3");
    }

    protected byte[] getBytesFromS3File(Object s3File) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getFileContents = s3File.getClass().getMethod("getByteContents", new Class[0]);
        return (byte[])getFileContents.invoke(s3File, new Object[0]);
    }

    protected boolean processRecords() {
        boolean s3DualSaveEnabled;
        boolean s3IntegrationEnabled = this.isS3IntegrationEnabled();
        if (!s3IntegrationEnabled) {
            LOG.info("S3 integration is not enabled.  Records will not be processed");
        }
        if (s3DualSaveEnabled = this.isS3DualSaveEnabled()) {
            LOG.info("S3 dual save is enabled.  Records will not be processed");
        }
        return s3IntegrationEnabled && !s3DualSaveEnabled;
    }

    protected boolean isS3IntegrationEnabled() {
        if (this.parameterService.parameterExists("KR-SYS", "All", "S3_INTEGRATION_ENABLED").booleanValue()) {
            return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_INTEGRATION_ENABLED");
        }
        return false;
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isDeleteFromFileSystem() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", DELETE_FILE_FROM_FILESYSTEM);
    }

    public S3FileService getRiceS3FileService() {
        return this.riceS3FileService;
    }

    public void setRiceS3FileService(S3FileService riceS3FileService) {
        this.riceS3FileService = riceS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

