/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import java.util.ArrayList;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.framework.engine.CompoundProposition;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.type.PropositionTypeService;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;

public class CompoundPropositionTypeService
implements PropositionTypeService {
    private RepositoryToEngineTranslator translator;

    public Proposition loadProposition(PropositionDefinition propositionDefinition) {
        if (this.translator == null) {
            throw new IllegalStateException("Service not configured properly, no translator available.");
        }
        if (propositionDefinition == null) {
            throw new IllegalArgumentException("propositionDefinition was null");
        }
        if (PropositionType.COMPOUND != PropositionType.fromCode((String)propositionDefinition.getPropositionTypeCode())) {
            throw new IllegalArgumentException("Given proposition definition was not compound, type code was: " + propositionDefinition.getPropositionTypeCode());
        }
        ArrayList<Proposition> propositions = new ArrayList<Proposition>();
        for (PropositionDefinition subProp : propositionDefinition.getCompoundComponents()) {
            propositions.add(this.translator.translatePropositionDefinition(subProp));
        }
        LogicalOperator operator = LogicalOperator.fromCode((String)propositionDefinition.getCompoundOpCode());
        return new CompoundProposition(operator, propositions);
    }

    public void setTranslator(RepositoryToEngineTranslator translator) {
        this.translator = translator;
    }
}

