/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.batch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.batch.BatchConnection;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private static final Integer ONE = new Integer(1);
    private static Method ADD_BATCH;
    private static final Method SET_BIG_DECIMAL;
    private final BatchConnection _batchConn;
    private final String _sql;
    private ArrayList _methods = new ArrayList();
    private ArrayList _params = new ArrayList();
    private Platform m_platform = null;

    public PreparedStatementInvocationHandler(BatchConnection batchConnection, String string, JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        this._batchConn = batchConnection;
        this._sql = string;
        this.m_platform = PlatformFactory.getPlatformFor(jdbcConnectionDescriptor);
        try {
            ADD_BATCH = this.m_platform.getClass().getMethod("addBatch", PreparedStatement.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ADD_BATCH = null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("executeUpdate")) {
            this._methods.add(ADD_BATCH);
            this._params.add(null);
            this._batchConn.nextExecuted(this._sql);
            return ONE;
        }
        if (string.equals("doExecute")) {
            this.doExecute((Connection)objectArray[0]);
        } else if (string.startsWith("set")) {
            if (string.equals("setLong")) {
                method = SET_BIG_DECIMAL;
                objectArray[1] = BigDecimal.valueOf((Long)objectArray[1]);
            }
            this._methods.add(method);
            this._params.add(objectArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Connection connection) throws SQLException {
        int n = this._methods.size();
        if (n == 0) {
            return;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(this._sql);
        try {
            this.m_platform.afterStatementCreate(preparedStatement);
        }
        catch (PlatformException platformException) {
            if (platformException.getCause() instanceof SQLException) {
                throw (SQLException)platformException.getCause();
            }
            throw new SQLException(platformException.getMessage());
        }
        try {
            this.m_platform.beforeBatch(preparedStatement);
        }
        catch (PlatformException platformException) {
            if (platformException.getCause() instanceof SQLException) {
                throw (SQLException)platformException.getCause();
            }
            throw new SQLException(platformException.getMessage());
        }
        try {
            for (int i = 0; i < n; ++i) {
                Method method = (Method)this._methods.get(i);
                try {
                    if (method.equals(ADD_BATCH)) {
                        this.m_platform.addBatch(preparedStatement);
                        continue;
                    }
                    method.invoke((Object)preparedStatement, (Object[])this._params.get(i));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuffer stringBuffer = this.generateExceptionMessage(i, preparedStatement, illegalArgumentException);
                    throw new SQLException(stringBuffer.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    StringBuffer stringBuffer = this.generateExceptionMessage(i, preparedStatement, illegalAccessException);
                    throw new SQLException(stringBuffer.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable == null) {
                        throwable = invocationTargetException;
                    }
                    if (throwable instanceof SQLException) {
                        throw (SQLException)throwable;
                    }
                    throw new SQLException(throwable.toString());
                }
                catch (PlatformException platformException) {
                    throw new SQLException(platformException.toString());
                }
            }
            try {
                this.m_platform.executeBatch(preparedStatement);
            }
            catch (PlatformException platformException) {
                if (platformException.getCause() instanceof SQLException) {
                    throw (SQLException)platformException.getCause();
                }
                throw new SQLException(platformException.getMessage());
            }
        }
        finally {
            preparedStatement.close();
            this._methods.clear();
            this._params.clear();
        }
    }

    private StringBuffer generateExceptionMessage(int n, PreparedStatement preparedStatement, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Method of type: ");
        stringBuffer.append(this._methods.get(n));
        stringBuffer.append(" invoking on instance: ");
        if (this._methods.get(n).equals(ADD_BATCH)) {
            stringBuffer.append(this.m_platform);
        } else {
            stringBuffer.append(preparedStatement);
        }
        stringBuffer.append(" with parameters: ");
        if (this._methods.get(n).equals(ADD_BATCH)) {
            stringBuffer.append(preparedStatement);
        } else {
            stringBuffer.append(this._params.get(n));
        }
        stringBuffer.append(" with root: ");
        stringBuffer.append(exception.toString());
        return stringBuffer;
    }

    static {
        Method method = null;
        try {
            method = PreparedStatement.class.getMethod("setBigDecimal", Integer.TYPE, BigDecimal.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SET_BIG_DECIMAL = method;
    }
}

