/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.ojb;

import java.util.Properties;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerNextValImpl;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;

@Deprecated
public class ConfigurableSequenceManager
implements SequenceManager {
    private static final String PROPERTY_PREFIX_ATTRIBUTE = "property.prefix";
    private static final String DEFAULT_PROPERTY_PREFIX = "datasource.ojb.sequenceManager";
    private static final String DEFAULT_SEQUENCE_MANAGER_CLASSNAME = SequenceManagerNextValImpl.class.getName();
    private PersistenceBroker broker;
    private SequenceManager sequenceManager;

    public ConfigurableSequenceManager(PersistenceBroker broker) {
        this.broker = broker;
        this.sequenceManager = this.createSequenceManager(broker);
    }

    protected SequenceManager createSequenceManager(PersistenceBroker broker) {
        String propertyPrefix = this.getPropertyPrefix();
        String sequenceManagerClassName = ConfigContext.getCurrentContextConfig().getProperty(this.getSequenceManagerClassNameProperty(propertyPrefix));
        if (StringUtils.isBlank((String)sequenceManagerClassName)) {
            sequenceManagerClassName = DEFAULT_SEQUENCE_MANAGER_CLASSNAME;
        }
        try {
            Class<?> sequenceManagerClass = ClassLoaderUtils.getDefaultClassLoader().loadClass(sequenceManagerClassName);
            Object sequenceManagerObject = ConstructorUtils.invokeConstructor(sequenceManagerClass, (Object)broker);
            if (!(sequenceManagerObject instanceof SequenceManager)) {
                throw new ConfigurationException("The configured sequence manager ('" + sequenceManagerClassName + "') is not an instance of '" + SequenceManager.class.getName() + "'");
            }
            SequenceManager sequenceManager = (SequenceManager)sequenceManagerObject;
            if (sequenceManager instanceof AbstractSequenceManager) {
                ((AbstractSequenceManager)sequenceManager).setConfigurationProperties(this.getSequenceManagerConfigProperties(propertyPrefix));
            }
            return sequenceManager;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Could not locate sequence manager with the given class '" + sequenceManagerClassName + "'", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConfigurationException("Property loading sequence manager class '" + sequenceManagerClassName + "'", (Throwable)e);
        }
    }

    protected String getSequenceManagerClassNameProperty(String propertyPrefix) {
        return propertyPrefix + ".className";
    }

    protected SequenceManager getConfiguredSequenceManager() {
        return this.sequenceManager;
    }

    protected Properties getSequenceManagerConfigProperties(String propertyPrefix) {
        Properties sequenceManagerProperties = new Properties();
        Properties properties = ConfigContext.getCurrentContextConfig().getProperties();
        String attributePrefix = propertyPrefix + ".attribute.";
        for (String string : properties.keySet()) {
            if (!string.startsWith(attributePrefix)) continue;
            String value = properties.getProperty(string);
            String attributeName = string.substring(attributePrefix.length());
            sequenceManagerProperties.setProperty(attributeName, value);
        }
        return sequenceManagerProperties;
    }

    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        this.getConfiguredSequenceManager().afterStore(jdbcAccess, classDescriptor, object);
    }

    public Object getUniqueValue(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        return this.getConfiguredSequenceManager().getUniqueValue(fieldDescriptor);
    }

    public PersistenceBroker getBroker() {
        return this.broker;
    }

    public String getPropertyPrefix() {
        SequenceDescriptor sd = this.getBroker().serviceConnectionManager().getConnectionDescriptor().getSequenceDescriptor();
        String propertyPrefix = null;
        if (sd != null) {
            propertyPrefix = sd.getConfigurationProperties().getProperty(PROPERTY_PREFIX_ATTRIBUTE);
        }
        if (StringUtils.isBlank(propertyPrefix)) {
            propertyPrefix = DEFAULT_PROPERTY_PREFIX;
        }
        return propertyPrefix;
    }
}

