/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceObjectFactory
implements ObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name jndiNameObject, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        XAResourceProducer resource;
        RefAddr refAddr;
        Reference ref = (Reference)obj;
        if (log.isDebugEnabled()) {
            log.debug("referencing resource with reference of type " + ref.getClass());
        }
        if ((refAddr = ref.get("uniqueName")) == null) {
            throw new NamingException("no 'uniqueName' RefAddr found");
        }
        Object content = refAddr.getContent();
        if (!(content instanceof String)) {
            throw new NamingException("'uniqueName' RefAddr content is not of type java.lang.String");
        }
        String uniqueName = (String)content;
        if (log.isDebugEnabled()) {
            log.debug("getting registered resource with uniqueName '" + uniqueName + "'");
        }
        if ((resource = ResourceRegistrar.get(uniqueName)) == null) {
            throw new NamingException("no resource registered with uniqueName '" + uniqueName + "', available resources: " + ResourceRegistrar.getResourcesUniqueNames());
        }
        return resource;
    }
}

