/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupInputField;
import org.kuali.rice.krad.lookup.LookupViewAuthorizerBase;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControlPostData;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.lifecycle.initialize.AssignIdsTask;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.util.GlobalVariables;

@BeanTag(name="lookupView", parent="Uif-LookupView")
public class LookupView
extends FormView {
    private static final long serialVersionUID = 716926008488403616L;
    private Class<?> dataObjectClass;
    private List<Component> criteriaFields;
    private Group criteriaGroup;
    @RequestParameter
    private boolean hideCriteriaOnSearch;
    private List<Component> resultFields;
    private CollectionGroup resultsGroup;
    private List<String> defaultSortAttributeNames;
    private boolean defaultSortAscending;
    @RequestParameter
    private Boolean renderReturnLink;
    @RequestParameter
    private boolean renderResultActions;
    @RequestParameter
    private Boolean renderMaintenanceLinks;
    @RequestParameter
    private boolean multipleValuesSelect;
    @RequestParameter
    private boolean renderLookupCriteria;
    @RequestParameter
    private boolean renderCriteriaActions;
    private Integer resultSetLimit;
    private Integer multipleValuesSelectResultSetLimit;
    private String maintenanceUrlMapping;
    private FieldGroup rangeFieldGroupPrototype;
    private Message rangedToMessage;
    private boolean autoAddActiveCriteria;
    private List<String> additionalSecurePropertyNames;

    public LookupView() {
        this.setViewTypeName(UifConstants.ViewType.LOOKUP);
        this.defaultSortAscending = true;
        this.autoAddActiveCriteria = true;
        this.renderLookupCriteria = true;
        this.renderCriteriaActions = true;
        this.renderResultActions = true;
        this.additionalSecurePropertyNames = new ArrayList<String>();
    }

    @Override
    public void performInitialization(Object model) {
        Lookupable lookupable = (Lookupable)this.getViewHelperService();
        lookupable.setDataObjectClass(this.dataObjectClass);
        this.initializeGroups();
        super.performInitialization(model);
        this.getObjectPathToConcreteClassMapping().put("lookupCriteria", this.getDataObjectClass());
        if (StringUtils.isNotBlank((String)this.getDefaultBindingObjectPath())) {
            this.getObjectPathToConcreteClassMapping().put(this.getDefaultBindingObjectPath(), this.getDataObjectClass());
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        TableLayoutManager resultsTableLayoutManager;
        LookupForm lookupForm = (LookupForm)model;
        if (!this.renderCriteriaActions || this.hideCriteriaOnSearch) {
            this.criteriaGroup.getFooter().setRender(false);
        }
        if (!this.renderLookupCriteria || this.hideCriteriaOnSearch && lookupForm.isDisplayResults()) {
            this.criteriaGroup.setRender(false);
        }
        if (this.hideCriteriaOnSearch && !lookupForm.isDisplayResults()) {
            this.resultsGroup.setRender(false);
        }
        boolean returnLinkAllowed = false;
        boolean maintenanceLinksAllowed = false;
        if (!this.multipleValuesSelect) {
            if (lookupForm.getInitialRequestParameters() != null && lookupForm.getInitialRequestParameters().containsKey("conversionFields")) {
                returnLinkAllowed = true;
            } else {
                maintenanceLinksAllowed = true;
            }
        } else {
            this.renderResultActions = false;
        }
        if (this.renderReturnLink == null) {
            this.renderReturnLink = returnLinkAllowed;
        }
        if (this.renderMaintenanceLinks == null) {
            this.renderMaintenanceLinks = maintenanceLinksAllowed;
        }
        if (this.renderMaintenanceLinks.booleanValue()) {
            LookupViewAuthorizerBase lookupAuthorizer = (LookupViewAuthorizerBase)this.getAuthorizer();
            Person user = GlobalVariables.getUserSession().getPerson();
            this.renderMaintenanceLinks = lookupAuthorizer.canInitiateMaintenanceDocument(this.getDataObjectClass().getName(), user);
        }
        if (this.getResultsGroup().getLayoutManager() instanceof TableLayoutManager && (resultsTableLayoutManager = (TableLayoutManager)this.getResultsGroup().getLayoutManager()).isAutoTruncateColumns() == null) {
            resultsTableLayoutManager.setAutoTruncateColumns(CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-KRAD", "Lookup", "AUTO_TRUNCATE_COLUMNS", Boolean.valueOf(false)));
        }
        this.convertLookupCriteriaFields(this.criteriaGroup);
        super.performApplyModel(model, parent);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        String dialogId;
        super.performFinalize(model, parent);
        LookupForm lookupForm = (LookupForm)model;
        String viewId = lookupForm.getViewId();
        HashMap<String, FilterableLookupCriteriaControlPostData> filterableLookupCriteria = new HashMap<String, FilterableLookupCriteriaControlPostData>();
        List<InputField> fields = ViewLifecycleUtils.getElementsOfTypeDeep(this.criteriaGroup, InputField.class);
        for (InputField field : fields) {
            field.setForceSessionPersistence(true);
            String propertyName = field.getPropertyName();
            if (!(field.getControl() instanceof FilterableLookupCriteriaControl)) continue;
            FilterableLookupCriteriaControl control = (FilterableLookupCriteriaControl)((Object)field.getControl());
            filterableLookupCriteria.put(propertyName, control.getPostData(propertyName));
        }
        ViewPostMetadata viewPostMetadata = ViewLifecycle.getViewPostMetadata();
        viewPostMetadata.addComponentPostData(viewId, "filterableLookupCriteria", filterableLookupCriteria);
        if (lookupForm.isReturnByScript()) {
            this.getAdditionalHiddenValues().put("returnByScript", "true");
        }
        if (StringUtils.isNotBlank((String)(dialogId = lookupForm.getShowDialogId()))) {
            List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(this.getFooter().getItems(), Action.class);
            for (Action action : actions) {
                action.addActionParameter("dialogId", dialogId);
            }
        } else {
            dialogId = lookupForm.getActionParamaterValue("dialogId");
            lookupForm.setShowDialogId(dialogId);
        }
    }

    protected void addActiveCriteriaIfNecessary() {
        LookupInputField activeLookupField;
        boolean isInactivatableClass = Inactivatable.class.isAssignableFrom(this.dataObjectClass);
        if (!this.autoAddActiveCriteria || !isInactivatableClass) {
            return;
        }
        boolean hasActiveCriteria = false;
        for (Component field : this.getCriteriaFields()) {
            if (!((InputField)field).getPropertyName().equals("active")) continue;
            hasActiveCriteria = true;
        }
        if (hasActiveCriteria) {
            return;
        }
        AttributeDefinition attributeDefinition = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeDefinition(this.dataObjectClass.getName(), "active");
        if (attributeDefinition == null) {
            activeLookupField = (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupActiveInputField");
        } else {
            activeLookupField = (LookupInputField)ComponentFactory.getNewComponentInstance("Uif-LookupCriteriaInputField");
            activeLookupField.setPropertyName("active");
            activeLookupField.copyFromAttributeDefinition(attributeDefinition);
        }
        this.getCriteriaFields().add(activeLookupField);
    }

    protected void initializeGroups() {
        if (this.getCriteriaGroup() != null && this.getCriteriaGroup().getItems().isEmpty()) {
            this.getCriteriaGroup().setItems(this.getCriteriaFields());
        }
        if (this.getResultsGroup() != null) {
            if (this.getResultsGroup().getItems().isEmpty() && this.getResultFields() != null) {
                this.getResultsGroup().setItems(this.getResultFields());
            }
            if (this.getResultsGroup().getCollectionObjectClass() == null) {
                this.getResultsGroup().setCollectionObjectClass(this.getDataObjectClass());
            }
        }
        if (this.getItems().isEmpty()) {
            this.setItems(Arrays.asList(this.getCriteriaGroup(), this.getResultsGroup()));
        }
    }

    protected void convertLookupCriteriaFields(Group lookupGroup) {
        List<? extends Component> criteriaGroupItems = lookupGroup.getItems();
        HashMap<Integer, FieldGroup> dateRangeFieldMap = new HashMap<Integer, FieldGroup>();
        int rangeIndex = 0;
        for (Component component : criteriaGroupItems) {
            if (component == null) continue;
            if (Group.class.isAssignableFrom(component.getClass())) {
                this.convertLookupCriteriaFields((Group)component);
            } else if (FieldGroup.class.isAssignableFrom(component.getClass())) {
                this.convertLookupCriteriaFields(((FieldGroup)component).getGroup());
            } else if (LookupInputField.class.isAssignableFrom(component.getClass())) {
                LookupInputField lookupInputField = (LookupInputField)component;
                Control control = lookupInputField.getControl();
                if (control instanceof TextControl) {
                    ((TextControl)control).setMaxLength(null);
                } else if (control instanceof TextAreaControl) {
                    ((TextAreaControl)control).setMaxLength(null);
                }
                if (lookupInputField.isRanged()) {
                    FieldGroup rangeFieldGroup = this.createDateRangeFieldGroup(lookupInputField);
                    dateRangeFieldMap.put(rangeIndex, rangeFieldGroup);
                }
            }
            ++rangeIndex;
        }
        for (Integer n : dateRangeFieldMap.keySet()) {
            criteriaGroupItems.set(n, (Component)dateRangeFieldMap.get(n));
        }
        this.criteriaGroup.setItems(criteriaGroupItems);
    }

    protected FieldGroup createDateRangeFieldGroup(LookupInputField toDate) {
        if (toDate.getId() == null) {
            toDate.setId(AssignIdsTask.generateId(toDate, ViewLifecycle.getView()));
        }
        FieldGroup rangeFieldGroup = ComponentUtils.copy(this.getRangeFieldGroupPrototype());
        rangeFieldGroup.setFieldLabel(ComponentUtils.copy(toDate.getFieldLabel()));
        rangeFieldGroup.setPropertyExpressions(toDate.getPropertyExpressions());
        rangeFieldGroup.setProgressiveRender(toDate.getProgressiveRender());
        rangeFieldGroup.setProgressiveRenderViaAJAX(toDate.isProgressiveRenderViaAJAX());
        rangeFieldGroup.setConditionalRefresh(toDate.getConditionalRefresh());
        rangeFieldGroup.setRefreshWhenChangedPropertyNames(toDate.getRefreshWhenChangedPropertyNames());
        rangeFieldGroup.setForceSessionPersistence(true);
        toDate.getFieldLabel().setRender(false);
        toDate.setRefreshWhenChangedPropertyNames(null);
        toDate.setForceSessionPersistence(true);
        LookupInputField fromDate = ComponentUtils.copy(toDate, "From");
        fromDate.getBindingInfo().setBindingName("rangeLowerBoundKeyPrefix_" + fromDate.getPropertyName());
        fromDate.setPropertyName("rangeLowerBoundKeyPrefix_" + fromDate.getPropertyName());
        fromDate.setOrder(0);
        ArrayList<ComponentBase> fieldGroupItems = new ArrayList<ComponentBase>();
        fieldGroupItems.add(fromDate);
        fieldGroupItems.add(this.rangedToMessage);
        fieldGroupItems.add(toDate);
        rangeFieldGroup.setItems(fieldGroupItems);
        return rangeFieldGroup;
    }

    @BeanTagAttribute(name="dataObjectClass")
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        try {
            this.dataObjectClass = Class.forName(dataObjectClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to set class for class name: " + dataObjectClassName, e);
        }
    }

    @BeanTagAttribute(name="renderReturnLink")
    public Boolean isRenderReturnLink() {
        return this.renderReturnLink;
    }

    public void setRenderReturnLink(Boolean renderReturnLink) {
        this.renderReturnLink = renderReturnLink;
    }

    @BeanTagAttribute(name="isRenderResultActions")
    public boolean isRenderResultActions() {
        return this.renderResultActions;
    }

    public void setRenderResultActions(boolean renderResultActions) {
        this.renderResultActions = renderResultActions;
    }

    @BeanTagAttribute(name="renderMaintenanceLinks")
    public Boolean isRenderMaintenanceLinks() {
        return this.renderMaintenanceLinks;
    }

    public void setRenderMaintenanceLinks(Boolean renderMaintenanceLinks) {
        this.renderMaintenanceLinks = renderMaintenanceLinks;
    }

    @BeanTagAttribute(name="multipleValueSelect")
    public boolean isMultipleValuesSelect() {
        return this.multipleValuesSelect;
    }

    public void setMultipleValuesSelect(boolean multipleValuesSelect) {
        this.multipleValuesSelect = multipleValuesSelect;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute(name="criteriaFields", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getCriteriaFields() {
        return this.criteriaFields;
    }

    public void setCriteriaFields(List<Component> criteriaFields) {
        this.criteriaFields = criteriaFields;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute(name="criteriaGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getCriteriaGroup() {
        return this.criteriaGroup;
    }

    public void setCriteriaGroup(Group criteriaGroup) {
        this.criteriaGroup = criteriaGroup;
    }

    public boolean isHideCriteriaOnSearch() {
        return this.hideCriteriaOnSearch;
    }

    public void setHideCriteriaOnSearch(boolean hideCriteriaOnSearch) {
        this.hideCriteriaOnSearch = hideCriteriaOnSearch;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute(name="resultFields", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(List<Component> resultFields) {
        this.resultFields = resultFields;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute(name="resultsGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CollectionGroup getResultsGroup() {
        return this.resultsGroup;
    }

    public void setResultsGroup(CollectionGroup resultsGroup) {
        this.resultsGroup = resultsGroup;
    }

    @BeanTagAttribute(name="defaultSortAttributeNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getDefaultSortAttributeNames() {
        return this.defaultSortAttributeNames;
    }

    public void setDefaultSortAttributeNames(List<String> defaultSortAttributeNames) {
        this.defaultSortAttributeNames = defaultSortAttributeNames;
    }

    @BeanTagAttribute(name="defaultSortAscending")
    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean defaultSortAscending) {
        this.defaultSortAscending = defaultSortAscending;
    }

    @BeanTagAttribute(name="resultSetLimit")
    public Integer getResultSetLimit() {
        return this.resultSetLimit;
    }

    public void setResultSetLimit(Integer resultSetLimit) {
        this.resultSetLimit = resultSetLimit;
    }

    @BeanTagAttribute(name="multipleValuesSelectResultSetLimit")
    public Integer getMultipleValuesSelectResultSetLimit() {
        return this.multipleValuesSelectResultSetLimit;
    }

    public void setMultipleValuesSelectResultSetLimit(Integer multipleValuesSelectResultSetLimit) {
        this.multipleValuesSelectResultSetLimit = multipleValuesSelectResultSetLimit;
    }

    @BeanTagAttribute(name="maintenanceUrlMapping")
    public String getMaintenanceUrlMapping() {
        return this.maintenanceUrlMapping;
    }

    public void setMaintenanceUrlMapping(String maintenanceUrlMapping) {
        this.maintenanceUrlMapping = maintenanceUrlMapping;
    }

    public boolean isRenderCriteriaActions() {
        return this.renderCriteriaActions;
    }

    public void setRenderCriteriaActions(boolean renderCriteriaActions) {
        this.renderCriteriaActions = renderCriteriaActions;
    }

    public boolean isRenderLookupCriteria() {
        return this.renderLookupCriteria;
    }

    public void setRenderLookupCriteria(boolean renderLookupCriteria) {
        this.renderLookupCriteria = renderLookupCriteria;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    public FieldGroup getRangeFieldGroupPrototype() {
        return this.rangeFieldGroupPrototype;
    }

    public void setRangeFieldGroupPrototype(FieldGroup rangeFieldGroupPrototype) {
        this.rangeFieldGroupPrototype = rangeFieldGroupPrototype;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    public Message getRangedToMessage() {
        return this.rangedToMessage;
    }

    public void setRangedToMessage(Message rangedToMessage) {
        this.rangedToMessage = rangedToMessage;
    }

    public boolean isAutoAddActiveCriteria() {
        return this.autoAddActiveCriteria;
    }

    public void setAutoAddActiveCriteria(boolean autoAddActiveCriteria) {
        this.autoAddActiveCriteria = autoAddActiveCriteria;
    }

    @BeanTagAttribute(name="additionalSecurePropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalSecurePropertyNames() {
        return this.additionalSecurePropertyNames;
    }

    public void setAdditionalSecurePropertyNames(List<String> additionalSecurePropertyNames) {
        this.additionalSecurePropertyNames = additionalSecurePropertyNames;
    }
}

