/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.identity.PrincipalId;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GenericRoleAttribute;
import org.kuali.rice.kew.rule.QualifiedRoleName;

public class UnitAdministratorRoleAttribute
extends GenericRoleAttribute {
    private static final long serialVersionUID = 2187135270043141363L;
    private static final Logger LOG = LogManager.getLogger(UnitAdministratorRoleAttribute.class);
    private static final String HOMEUNIT = "homeUnit";
    private boolean getUnits = true;
    private String roleName = "Department Head";
    private String unitAdministratorCode = "3";
    UnitService unitService;

    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        if (roleName != null) {
            String[] info = roleName.split("!");
            if (info.length != 3) {
                LOG.warn("Not enough parameters in the roleName.");
            } else {
                this.roleName = info[0];
                this.unitAdministratorCode = info[1];
                if (info[2].toUpperCase().equals("FALSE")) {
                    this.getUnits = false;
                }
            }
        }
        ArrayList<String> qualifiedRoleNames = new ArrayList<String>();
        qualifiedRoleNames.add(this.roleName);
        return qualifiedRoleNames;
    }

    public List<RoleName> getRoleNames() {
        RoleName role = RoleName.Builder.create((String)UnitAdministratorRoleAttribute.class.getName(), (String)this.roleName, (String)this.roleName).build();
        return Collections.singletonList(role);
    }

    public Map<String, String> getProperties() {
        return null;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    protected List<Id> resolveRecipients(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        ArrayList<Id> members = new ArrayList<Id>();
        Collection<Element> personnels = this.retrieveKeyPersonnel(routeContext);
        for (Element keyPerson : personnels) {
            Unit unit;
            Collection units;
            if (this.getUnits) {
                units = XmlHelper.findElements((Element)keyPerson, (String)ProposalPersonUnit.class.getName());
                for (Element unitElement : units) {
                    unit = this.getUnitService().getUnit(unitElement.getChildText("unitNumber"));
                    List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(unit.getUnitNumber());
                    for (UnitAdministrator unitAdministrator : unitAdministrators) {
                        PrincipalId personId;
                        if (!StringUtils.isNotBlank((CharSequence)unitAdministrator.getPersonId()) || !unitAdministrator.getUnitAdministratorType().getCode().equals(this.unitAdministratorCode) || members.contains(personId = new PrincipalId(unitAdministrator.getPersonId()))) continue;
                        members.add((Id)personId);
                    }
                }
                continue;
            }
            units = XmlHelper.findElements((Element)keyPerson, (String)ProposalPersonUnit.class.getName());
            for (Element unitElement : units) {
                unit = this.getUnitService().getUnit(unitElement.getChildText("unitNumber"));
                Unit parentUnit = unit.getParentUnit();
                if (parentUnit == null) continue;
                List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(parentUnit.getUnitNumber());
                for (UnitAdministrator unitAdministrator : unitAdministrators) {
                    PrincipalId personId;
                    if (!StringUtils.isNotBlank((CharSequence)unitAdministrator.getPersonId()) || !unitAdministrator.getUnitAdministratorType().getCode().equals(this.unitAdministratorCode) || members.contains(personId = new PrincipalId(unitAdministrator.getPersonId()))) continue;
                    members.add((Id)personId);
                }
            }
        }
        return members;
    }

    protected Collection<Element> retrieveKeyPersonnel(RouteContext context) {
        Document document = XmlHelper.buildJDocument((org.w3c.dom.Document)context.getDocumentContent().getDocument());
        Collection personnels = XmlHelper.findElements((Element)document.getRootElement(), (String)ProposalPerson.class.getName());
        return personnels;
    }
}

