/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectPersonRoleType;
import org.kuali.kra.excon.project.ExconProjectTraveler;
import org.kuali.kra.excon.project.ExconProjectUnitContactTypeValuesFinder;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class ExconProjectPerson
extends ExconProjectAssociate
implements AbstractPersonRoleAware {
    private static final long serialVersionUID = 4063631952041257985L;
    private Long exconProjectPersonId;
    private String personId;
    private Integer rolodexId;
    private String fullName;
    private String roleTypeCode;
    private ExconProjectPersonRoleType roleType;
    private ExconProjectTraveler traveler;
    private Long projectId;
    private String userName;
    private transient KcPersonService kcPersonService;

    public Long getExconProjectPersonId() {
        return this.exconProjectPersonId;
    }

    public void setExconProjectPersonId(Long exconProjectPersonId) {
        this.exconProjectPersonId = exconProjectPersonId;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFullName() {
        KcPerson person;
        if (this.fullName == null && (person = this.getPerson()) != null) {
            this.fullName = person.getFullName();
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getRoleTypeCode() {
        return this.roleTypeCode;
    }

    public void setRoleTypeCode(String roleTypeCode) {
        this.roleTypeCode = roleTypeCode;
    }

    public ExconProjectPersonRoleType getRoleType() {
        if (!StringUtils.isEmpty((CharSequence)this.roleTypeCode)) {
            this.refreshReferenceObject("roleType");
        }
        return this.roleType;
    }

    public String getPersonRoleTypeName() {
        if (this.roleTypeCode != null) {
            return new ExconProjectUnitContactTypeValuesFinder().getKeyLabel(this.roleTypeCode);
        }
        return null;
    }

    public void setRoleType(ExconProjectPersonRoleType roleType) {
        this.roleType = roleType;
    }

    public ExconProjectTraveler getTraveler() {
        return this.traveler;
    }

    public void setTraveler(ExconProjectTraveler traveler) {
        this.traveler = traveler;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public boolean getIsUnitRestricted() {
        if (this.getPerson() == null || this.getPerson().getUnit() == null) {
            return false;
        }
        return this.getExconProject().isUnitRestricted(this.getPerson().getUnit().getUnitNumber());
    }

    @Override
    public void resetPersistenceState() {
        this.exconProjectPersonId = null;
        this.versionNumber = null;
    }

    @Override
    public KcPerson getPerson() {
        if (this.personId != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        if (this.userName != null) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.userName);
            if (person != null) {
                this.setPersonId(person.getPersonId());
            }
            return person;
        }
        return null;
    }

    @Override
    public PersistableBusinessObject getParent() {
        return null;
    }

    @Override
    public String getRoleCode() {
        return this.roleTypeCode;
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ExconProjectPerson && ((ExconProjectPerson)o).getExconProjectPersonId().equals(this.getExconProjectPersonId());
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

