/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonServiceFactory;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.core.BudgetVersionFormBase;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.propdev.impl.lock.ProposalLockService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetActionBase
extends KcTransactionalDocumentActionBase {
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    protected static final String COPY_BUDGET_PERIOD_QUESTION = "copyBudgetQuestion";
    protected static final String QUESTION_TYPE = "copyPeriodsQuestion";
    protected static final String QUESTION_TEXT = "A new version of the budget will be created based on version ";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetVersionFormBase proposalForm = (BudgetVersionFormBase)form;
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    protected void copyBudget(BudgetParentDocument budgetParentDocument, Budget budgetToCopy, boolean copyPeriodOneOnly) throws WorkflowException {
        DocumentService documentService = KcServiceLocator.getService(DocumentService.class);
        AwardBudgetDocument budgetDocToCopy = (AwardBudgetDocument)documentService.getByDocumentHeaderId(budgetToCopy.getDocumentNumber());
        AwardBudgetExt budget = budgetDocToCopy.getBudget();
        BudgetCommonService<BudgetParent> budgetService = this.getBudgetCommonService(((Budget)budget).getBudgetParent());
        Budget newBudget = budgetService.copyBudgetVersion(budget, copyPeriodOneOnly);
        newBudget.setNameUpdatable(true);
        newBudget.setName(budgetToCopy.getName() + " " + budgetToCopy.getBudgetVersionNumber() + " copy");
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParent budgetParent) {
        return BudgetCommonServiceFactory.createInstance(budgetParent);
    }

    protected void populateTabState(KualiForm form, String tabTitle) {
        form.getTabStates().put(WebUtils.generateTabKey((String)tabTitle), "OPEN");
    }

    protected PessimisticLockService getPessimisticLockService() {
        return KcServiceLocator.getService(ProposalLockService.class);
    }

    protected void setupPessimisticLockMessages(Document document, HttpServletRequest request) {
        super.setupPessimisticLockMessages(document, request);
        List lockMessages = (List)request.getAttribute("DocumentPessimisticLockMessages");
        AwardBudgetDocument budgetDoc = (AwardBudgetDocument)document;
        for (PessimisticLock lock : budgetDoc.getBudget().getBudgetParent().getDocument().getPessimisticLocks()) {
            String message;
            if (!StringUtils.contains((CharSequence)lock.getLockDescriptor(), (CharSequence)"BUDGET") || lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson()) || lockMessages.contains(message = this.generatePessimisticLockMessage(lock))) continue;
            lockMessages.add(message);
        }
        request.setAttribute("DocumentPessimisticLockMessages", (Object)lockMessages);
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        if (this.kcBusinessRulesEngine == null) {
            this.kcBusinessRulesEngine = KcServiceLocator.getService(KcBusinessRulesEngine.class);
        }
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }
}

