/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.document;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.api.rule.RuleTemplateAttributeContract;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.rule.GroupRuleResponsibility;
import org.kuali.rice.kew.rule.PersonRuleResponsibility;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class RoutingRuleMaintainableBusRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        RuleBaseValues ruleBaseValues = this.getRuleBaseValues(document);
        RuleBaseValues oldRuleBaseValues = this.getOldRuleBaseValues(document);
        return isValid &= this.populateErrorMap(ruleBaseValues);
    }

    protected RuleBaseValues getRuleBaseValues(MaintenanceDocument document) {
        return (RuleBaseValues)document.getNewMaintainableObject().getBusinessObject();
    }

    protected RuleBaseValues getOldRuleBaseValues(MaintenanceDocument document) {
        return (RuleBaseValues)document.getOldMaintainableObject().getBusinessObject();
    }

    protected void populateErrorMap(Map<String, String> errorMap) {
        for (Map.Entry<String, String> entry : errorMap.entrySet()) {
            this.putFieldError(entry.getKey(), entry.getValue());
        }
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        GroupRuleResponsibility gr;
        boolean isValid = true;
        if (this.getPersonSectionName().equals(collectionName)) {
            PersonRuleResponsibility pr = (PersonRuleResponsibility)line;
            String name = pr.getPrincipalName();
            if (!this.personExists(name)) {
                isValid &= false;
                this.putFieldError(this.getPersonSectionName(), "error.document.personResponsibilities.principleDoesNotExist");
            }
        } else if (this.getGroupSectionName().equals(collectionName) && !this.groupExists((gr = (GroupRuleResponsibility)line).getNamespaceCode(), gr.getName())) {
            isValid &= false;
            this.putFieldError(this.getGroupSectionName(), "error.document.personResponsibilities.groupDoesNotExist");
        }
        return isValid;
    }

    protected String getPersonSectionName() {
        return "personResponsibilities";
    }

    protected String getGroupSectionName() {
        return "groupResponsibilities";
    }

    protected boolean personExists(String principalName) {
        boolean bRet = false;
        try {
            KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
            bRet = true;
        }
        catch (Exception ex) {
            bRet = false;
        }
        return bRet;
    }

    protected boolean groupExists(String namespaceCode, String groupName) {
        boolean bRet = false;
        try {
            KEWServiceLocator.getIdentityHelperService().getGroupByName(namespaceCode, groupName);
            bRet = true;
        }
        catch (Exception ex) {
            bRet = false;
        }
        return bRet;
    }

    protected boolean populateErrorMap(RuleBaseValues ruleBaseValues) {
        boolean isValid = true;
        if (this.getDocumentTypeService().findByName(ruleBaseValues.getDocTypeName()) == null) {
            this.putFieldError("docTypeName", "doctype.documenttypeservice.doctypename.required");
            isValid = false;
        }
        if (ruleBaseValues.getName() != null && this.ruleExists(ruleBaseValues)) {
            this.putFieldError("name", "routetemplate.ruleservice.name.unique");
            isValid = false;
        }
        if (ruleBaseValues.getToDateValue() != null && ruleBaseValues.getFromDateValue() != null && ruleBaseValues.getToDateValue().before(ruleBaseValues.getFromDateValue())) {
            this.putFieldError("toDate", "error.document.maintainableItems.toDate");
            isValid = false;
        }
        if (!this.setRuleAttributeErrors(ruleBaseValues)) {
            isValid = false;
        }
        if (ruleBaseValues.getPersonResponsibilities().isEmpty() && ruleBaseValues.getGroupResponsibilities().isEmpty() && ruleBaseValues.getRoleResponsibilities().isEmpty()) {
            this.putFieldError("Persons", "error.document.responsibility.required");
            isValid = false;
        } else {
            for (PersonRuleResponsibility personRuleResponsibility : ruleBaseValues.getPersonResponsibilities()) {
                if (!StringUtils.isBlank((CharSequence)personRuleResponsibility.getPrincipalName()) && KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(personRuleResponsibility.getPrincipalName()) != null) continue;
                this.putFieldError("Persons", "routetemplate.ruleservice.user.invalid");
                isValid = false;
                break;
            }
            for (GroupRuleResponsibility groupRuleResponsibility : ruleBaseValues.getGroupResponsibilities()) {
                if (!StringUtils.isBlank((CharSequence)groupRuleResponsibility.getNamespaceCode()) && !StringUtils.isBlank((CharSequence)groupRuleResponsibility.getName()) && RoutingRuleMaintainableBusRule.getGroupService().getGroupByNamespaceCodeAndName(groupRuleResponsibility.getNamespaceCode(), groupRuleResponsibility.getName()) != null) continue;
                this.putFieldError("Groups", "routetemplate.ruleservice.workgroup.invalid");
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    protected boolean ruleExists(RuleBaseValues rule) {
        boolean bRet = false;
        RuleBaseValues tmp = KEWServiceLocator.getRuleService().getRuleByName(rule.getName());
        if (tmp != null && (rule.getPreviousRuleId() == null || rule.getPreviousRuleId() != null && !rule.getPreviousRuleId().equals(tmp.getId()))) {
            bRet = true;
        }
        return bRet;
    }

    protected DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    protected boolean setRuleAttributeErrors(RuleBaseValues rule) {
        boolean isValid = true;
        RuleTemplate ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplate(rule.getRuleTemplateId());
        for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
            if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
            Map<String, String> parameterMap = WebRuleUtils.getFieldMapForRuleTemplateAttribute(rule, (RuleTemplateAttributeContract)ruleTemplateAttribute);
            WorkflowRuleAttributeRows rows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRuleRows(parameterMap, ruleTemplateAttribute);
            List<RemotableAttributeError> errors = rows.getValidationErrors();
            if (errors.isEmpty()) continue;
            isValid = false;
            for (RemotableAttributeError error : errors) {
                this.putFieldError("RuleAttributes", "error.custom", error.getMessage());
            }
        }
        return isValid;
    }
}

