/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.DbSpecificOption;

public class DbConfigTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final List<PropertyDescriptor> options = new ArrayList<PropertyDescriptor>();
    private Config config = Config.getInstance();

    public DbConfigTableModel() {
        PropertyDescriptor[] propertyDescriptorArray = this.getConfigProps();
        this.options.add(this.getDescriptor("outputDir", "Directory to generate HTML output to", propertyDescriptorArray));
        this.options.add(this.getDescriptor("schema", "Schema to evaluate", propertyDescriptorArray));
        this.options.add(this.getDescriptor("user", "User ID to connect with", propertyDescriptorArray));
        this.options.add(this.getDescriptor("password", "Password associated with user id", propertyDescriptorArray));
        this.options.add(this.getDescriptor("impliedConstraintsEnabled", "XXXX", propertyDescriptorArray));
    }

    public void setDbSpecificConfig(DbSpecificConfig dbSpecificConfig) {
        this.config = dbSpecificConfig.getConfig();
        Config.setInstance(this.config);
        PropertyDescriptor[] propertyDescriptorArray = this.getConfigProps();
        this.removeDbSpecificOptions();
        for (DbSpecificOption dbSpecificOption : dbSpecificConfig.getOptions()) {
            PropertyDescriptor propertyDescriptor = this.getDescriptor(dbSpecificOption.getName(), dbSpecificOption.getDescription(), propertyDescriptorArray);
            propertyDescriptor.setValue("dbSpecific", Boolean.TRUE);
            this.options.add(propertyDescriptor);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Option";
            }
        }
        return "Value";
    }

    private PropertyDescriptor getDescriptor(String string, String string2, PropertyDescriptor[] propertyDescriptorArray) {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = this.getConfigProps();
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equalsIgnoreCase(string)) continue;
            propertyDescriptor.setShortDescription(string2);
            return propertyDescriptor;
        }
        throw new IllegalArgumentException(string + " is not a valid configuration item");
    }

    private PropertyDescriptor[] getConfigProps() throws RuntimeException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(Config.class);
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException(introspectionException);
        }
        return beanInfo.getPropertyDescriptors();
    }

    private void removeDbSpecificOptions() {
        Iterator<PropertyDescriptor> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor propertyDescriptor = iterator.next();
            if (propertyDescriptor.getValue("dbSpecific") == null) continue;
            iterator.remove();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.options.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 != 1) {
            return false;
        }
        return this.options.get(n).getWriteMethod() != null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PropertyDescriptor propertyDescriptor = this.options.get(n);
        switch (n2) {
            case 0: {
                return propertyDescriptor.getName();
            }
            case 1: {
                try {
                    Object object = propertyDescriptor.getReadMethod().invoke((Object)this.config, (Object[])null);
                    return object;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getCause() instanceof Config.MissingRequiredParameterException) {
                        return null;
                    }
                    throw new RuntimeException(invocationTargetException);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (!(object2 == object || object != null && object2 != null && object.equals(object2))) {
            PropertyDescriptor propertyDescriptor = this.options.get(n);
            try {
                if (object instanceof String && propertyDescriptor.getPropertyType().isAssignableFrom(Integer.class)) {
                    try {
                        object = Integer.valueOf((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = object2;
                    }
                }
                propertyDescriptor.getWriteMethod().invoke((Object)this.config, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    public Class<?> getClass(int n) {
        PropertyDescriptor propertyDescriptor = this.options.get(n);
        return propertyDescriptor.getPropertyType();
    }

    public String getDescription(int n) {
        PropertyDescriptor propertyDescriptor = this.options.get(n);
        return propertyDescriptor.getShortDescription();
    }
}

