/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentViewAuthorizer;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.print.ProposalDevelopmentPrintingService;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentPrintController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="proposalDevelopmentPrintingService")
    private ProposalDevelopmentPrintingService proposalDevelopmentPrintingService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="proposalDevelopmentDocumentViewAuthorizer")
    private ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=preparePrintDialog"})
    public ModelAndView preparePrintDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.getProposalDevelopmentPrintingService().populateSponsorForms(form.getSponsorFormTemplates(), form.getDevelopmentProposal().getSponsorCode());
        form.setPrintS2sOppForms(form.getDevelopmentProposal().getS2sOppForms());
        return this.getModelAndViewService().showDialog("PropDev-Print-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printSponsorForms"})
    public ModelAndView printSponsorForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)form.getProposalDevelopmentDocument(), this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printSponsorForms", "Proposal");
        }
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("Selected Templates", this.getProposalDevelopmentPrintingService().getSponsorFormTemplates(form.getSponsorFormTemplates()));
        AttachmentDataSource dataStream = this.getProposalDevelopmentPrintingService().printProposalDevelopmentReport(form.getDevelopmentProposal(), "Print Proposal Sponsor Forms", reportParameters);
        ControllerFileUtils.streamToResponse(dataStream, response);
        return null;
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=generateReport"})
    public ModelAndView generateReport(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)form.getProposalDevelopmentDocument(), this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printReport", "Proposal");
        }
        form.getReportHelper().getCurrentReportBeans().clear();
        form.getReportHelper().getPendingReportBeans().clear();
        form.getReportHelper().setTargetPerson(this.getKcPersonService().getKcPersonByPersonId(form.getReportHelper().getPersonId()));
        if (StringUtils.equals((CharSequence)form.getReportHelper().getReportType(), (CharSequence)"current")) {
            form.getReportHelper().prepareCurrentReport();
        } else {
            form.getReportHelper().preparePendingReport();
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printReport"})
    public ModelAndView printReport(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)form.getProposalDevelopmentDocument(), this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printReport", "Proposal");
        }
        form.getReportHelper().setTargetPerson(this.getKcPersonService().getKcPersonByPersonId(form.getReportHelper().getPersonId()));
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("personId", form.getReportHelper().getPersonId());
        reportParameters.put("reportPersonName", form.getReportHelper().getTargetPerson().getFullName());
        AttachmentDataSource dataStream = StringUtils.equals((CharSequence)form.getReportHelper().getReportType(), (CharSequence)"current") ? form.getReportHelper().getCurrentAndPendingReportService().printCurrentReport(reportParameters) : form.getReportHelper().getCurrentAndPendingReportService().printPendingReport(reportParameters);
        ControllerFileUtils.streamToResponse(dataStream, response);
        return null;
    }

    public ProposalDevelopmentPrintingService getProposalDevelopmentPrintingService() {
        return this.proposalDevelopmentPrintingService;
    }

    public void setProposalDevelopmentPrintingService(ProposalDevelopmentPrintingService proposalDevelopmentPrintingService) {
        this.proposalDevelopmentPrintingService = proposalDevelopmentPrintingService;
    }

    @Override
    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    @Override
    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public ProposalDevelopmentDocumentViewAuthorizer getProposalDevelopmentDocumentViewAuthorizer() {
        return this.proposalDevelopmentDocumentViewAuthorizer;
    }

    public void setProposalDevelopmentDocumentViewAuthorizer(ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer) {
        this.proposalDevelopmentDocumentViewAuthorizer = proposalDevelopmentDocumentViewAuthorizer;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }
}

