/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.rules;

import java.sql.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.rule.event.TimeAndMoneyAwardAmountTransactionSaveEvent;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardAmountTransactionRule;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class TimeAndMoneyAwardAmountTransactionRuleImpl
extends KcTransactionalDocumentRuleBase
implements TimeAndMoneyAwardAmountTransactionRule {
    private static final String NEW_AWARD_AMOUNT_TRANSACTION = "newAwardAmountTransaction";
    private static final String TRANSACTION_TYPE_CODE = ".transactionTypeCode";
    private static final String AMOUNTS_INVALID_FROM_TRANSACTIONS = "document.pendingTransactionsCauseErrors";
    private AwardVersionService awardVersionService;
    private AwardAmountInfoService awardAmountInfoService;

    @Override
    public boolean processSaveAwardAmountTransactionBusinessRules(TimeAndMoneyAwardAmountTransactionSaveEvent timeAndMoneyAwardAmountTransactionSaveEvent) {
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyAwardAmountTransactionSaveEvent.getDocument();
        boolean valid = true;
        if (!timeAndMoneyDocument.isInitialSave()) {
            if (timeAndMoneyDocument.getAwardAmountTransactions().size() > 0) {
                if (timeAndMoneyDocument.getAwardAmountTransactions().get(0).getTransactionTypeCode() == null) {
                    valid = false;
                    this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
                }
            } else if (timeAndMoneyDocument.getNewAwardAmountTransaction() == null || timeAndMoneyDocument.getNewAwardAmountTransaction().getTransactionTypeCode() == null) {
                valid = false;
                this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
            }
            if (timeAndMoneyDocument.getPendingTransactions().size() > 0) {
                for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
                    Award award = this.getAwardVersionService().getWorkingAwardVersion(awardHierarchyNode.getValue().getAwardNumber());
                    award.refreshReferenceObject("awardAmountInfos");
                    AwardAmountInfo aai = this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
                    Date obligatedStartDate = aai.getCurrentFundEffectiveDate();
                    Date obligatedEndDate = aai.getObligationExpirationDate();
                    ScaleTwoDecimal obligatedTotal = aai.getAmountObligatedToDate();
                    ScaleTwoDecimal anticipatedTotal = aai.getAnticipatedTotalAmount();
                    for (PendingTransaction pendingTransaction : timeAndMoneyDocument.getPendingTransactions()) {
                        if (pendingTransaction.getProcessedFlag().booleanValue()) continue;
                        if (StringUtils.equals((CharSequence)pendingTransaction.getSourceAwardNumber(), (CharSequence)award.getAwardNumber())) {
                            anticipatedTotal = (ScaleTwoDecimal)anticipatedTotal.subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount());
                            obligatedTotal = (ScaleTwoDecimal)obligatedTotal.subtract((AbstractDecimal)pendingTransaction.getObligatedAmount());
                        }
                        if (!StringUtils.equals((CharSequence)pendingTransaction.getDestinationAwardNumber(), (CharSequence)award.getAwardNumber())) continue;
                        anticipatedTotal = (ScaleTwoDecimal)anticipatedTotal.add((AbstractDecimal)pendingTransaction.getAnticipatedAmount());
                        obligatedTotal = (ScaleTwoDecimal)obligatedTotal.add((AbstractDecimal)pendingTransaction.getObligatedAmount());
                    }
                    MessageMap errorMap = GlobalVariables.getMessageMap();
                    errorMap.clearErrorPath();
                    if (obligatedTotal.isGreaterThan((AbstractDecimal)anticipatedTotal)) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.anticipated.amount.from.transactions", award.getAwardNumber());
                    }
                    if (anticipatedTotal.isNegative()) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.anticipated.negative.from.transactions", award.getAwardNumber());
                    }
                    if (obligatedTotal.isNegative()) {
                        valid = false;
                        this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.obligated.negative.from.transactions", award.getAwardNumber());
                    }
                    if (!obligatedTotal.isPositive() || obligatedStartDate != null && obligatedEndDate != null) continue;
                    valid = false;
                    this.reportError(AMOUNTS_INVALID_FROM_TRANSACTIONS, "error.award.obligated.dates.from.transactions", award.getAwardNumber());
                }
            }
        }
        return valid;
    }

    public AwardVersionService getAwardVersionService() {
        if (this.awardVersionService == null) {
            this.awardVersionService = KcServiceLocator.getService(AwardVersionService.class);
        }
        return this.awardVersionService;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        if (this.awardAmountInfoService == null) {
            this.awardAmountInfoService = KcServiceLocator.getService(AwardAmountInfoService.class);
        }
        return this.awardAmountInfoService;
    }
}

