/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateAttributeBo;

@Entity
@Table(name="KRMS_NL_TMPL_T")
public class NaturalLanguageTemplateBo
implements NaturalLanguageTemplateContract,
Versioned,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    @Transient
    private Map<String, String> attributes;
    @Column(name="LANG_CD")
    private String languageCode;
    @Column(name="NL_USAGE_ID")
    private String naturalLanguageUsageId;
    @Column(name="TYP_ID")
    private String typeId;
    @Column(name="TMPL")
    private String template;
    @PortableSequenceGenerator(name="KRMS_NL_TMPL_S")
    @GeneratedValue(generator="KRMS_NL_TMPL_S")
    @Id
    @Column(name="NL_TMPL_ID")
    private String id;
    @Column(name="ACTV")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    @OneToMany(targetEntity=NaturalLanguageTemplateAttributeBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="NL_TMPL_ID", referencedColumnName="NL_TMPL_ID", insertable=false, updatable=false)
    private Set<NaturalLanguageTemplateAttributeBo> attributeBos;
    private static KrmsAttributeDefinitionService attributeDefinitionService;
    private static KrmsTypeRepositoryService typeRepositoryService;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public String getLanguageCode() {
        return this._persistence_get_languageCode();
    }

    public String getNaturalLanguageUsageId() {
        return this._persistence_get_naturalLanguageUsageId();
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public String getTemplate() {
        return this._persistence_get_template();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setLanguageCode(String languageCode) {
        this._persistence_set_languageCode(languageCode);
    }

    public void setNaturalLanguageUsageId(String naturalLanguageUsageId) {
        this._persistence_set_naturalLanguageUsageId(naturalLanguageUsageId);
    }

    public void setTypeId(String typeId) {
        this._persistence_set_typeId(typeId);
    }

    public void setTemplate(String template) {
        this._persistence_set_template(template);
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public void setAttributeBos(List<NaturalLanguageTemplateAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(new HashSet<NaturalLanguageTemplateAttributeBo>(attributeBos));
    }

    public void setAttributeBos(Set<NaturalLanguageTemplateAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(new HashSet<NaturalLanguageTemplateAttributeBo>(attributeBos));
    }

    public static NaturalLanguageTemplate to(NaturalLanguageTemplateBo naturalLanguageTemplateBo) {
        if (naturalLanguageTemplateBo == null) {
            return null;
        }
        return NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplateBo).build();
    }

    public static NaturalLanguageTemplateBo from(NaturalLanguageTemplate naturalLanguageTemplate) {
        if (naturalLanguageTemplate == null) {
            return null;
        }
        NaturalLanguageTemplateBo naturalLanguageTemplateBo = new NaturalLanguageTemplateBo();
        naturalLanguageTemplateBo.setLanguageCode(naturalLanguageTemplate.getLanguageCode());
        naturalLanguageTemplateBo.setNaturalLanguageUsageId(naturalLanguageTemplate.getNaturalLanguageUsageId());
        naturalLanguageTemplateBo.setTypeId(naturalLanguageTemplate.getTypeId());
        naturalLanguageTemplateBo.setTemplate(naturalLanguageTemplate.getTemplate());
        naturalLanguageTemplateBo.setId(naturalLanguageTemplate.getId());
        naturalLanguageTemplateBo.setActive(naturalLanguageTemplate.isActive());
        naturalLanguageTemplateBo.setVersionNumber(naturalLanguageTemplate.getVersionNumber());
        if (StringUtils.isNotBlank((String)naturalLanguageTemplate.getId())) {
            naturalLanguageTemplateBo.setAttributeBos(NaturalLanguageTemplateBo.buildAttributeBoSet(naturalLanguageTemplate));
        }
        return naturalLanguageTemplateBo;
    }

    public Map<String, String> getAttributes() {
        if (this._persistence_get_attributeBos() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>(this._persistence_get_attributeBos().size());
        for (NaturalLanguageTemplateAttributeBo attr : this._persistence_get_attributeBos()) {
            attributes.put(attr.getAttributeDefinition().getName(), attr.getValue());
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this._persistence_set_attributeBos(new HashSet());
        if (!StringUtils.isBlank((String)this._persistence_get_typeId())) {
            List<KrmsAttributeDefinition> attributeDefinitions = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().findAttributeDefinitionsByType(this.getTypeId());
            HashMap<String, KrmsAttributeDefinition> attributeDefinitionsByName = new HashMap<String, KrmsAttributeDefinition>(attributeDefinitions.size());
            if (attributeDefinitions != null) {
                for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
                    attributeDefinitionsByName.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                KrmsAttributeDefinition attributeDefinition = (KrmsAttributeDefinition)attributeDefinitionsByName.get(entry.getKey());
                NaturalLanguageTemplateAttributeBo attributeBo = new NaturalLanguageTemplateAttributeBo();
                attributeBo.setNaturalLanguageTemplateId(this.getId());
                attributeBo.setAttributeDefinitionId(attributeDefinition == null ? null : attributeDefinition.getId());
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attributeDefinition));
                this._persistence_get_attributeBos().add(attributeBo);
            }
        }
    }

    private static Collection<NaturalLanguageTemplateAttributeBo> buildAttributes(NaturalLanguageTemplate im, Collection<NaturalLanguageTemplateAttributeBo> attributes) {
        KrmsTypeDefinition krmsTypeDefinition = NaturalLanguageTemplateBo.getTypeRepositoryService().getTypeById(im.getTypeId());
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = NaturalLanguageTemplateBo.getAttributeDefinitionService().getAttributeDefinitionByNameAndNamespace((String)entry.getKey(), krmsTypeDefinition.getNamespace());
                if (attrDef != null) {
                    NaturalLanguageTemplateAttributeBo attributeBo = new NaturalLanguageTemplateAttributeBo();
                    attributeBo.setNaturalLanguageTemplateId(im.getId());
                    attributeBo.setAttributeDefinitionId(attrDef.getId());
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the naturalLanguageTemplate type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private static Set<NaturalLanguageTemplateAttributeBo> buildAttributeBoSet(NaturalLanguageTemplate im) {
        HashSet<NaturalLanguageTemplateAttributeBo> attributes = new HashSet<NaturalLanguageTemplateAttributeBo>();
        return (Set)NaturalLanguageTemplateBo.buildAttributes(im, attributes);
    }

    private static List<NaturalLanguageTemplateAttributeBo> buildAttributeBoList(NaturalLanguageTemplate im) {
        LinkedList<NaturalLanguageTemplateAttributeBo> attributes = new LinkedList<NaturalLanguageTemplateAttributeBo>();
        return (List)NaturalLanguageTemplateBo.buildAttributes(im, attributes);
    }

    public static void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        NaturalLanguageTemplateBo.attributeDefinitionService = attributeDefinitionService;
    }

    public static KrmsTypeRepositoryService getTypeRepositoryService() {
        if (typeRepositoryService == null) {
            typeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        }
        return typeRepositoryService;
    }

    public static void setTypeRepositoryService(KrmsTypeRepositoryService typeRepositoryService) {
        NaturalLanguageTemplateBo.typeRepositoryService = typeRepositoryService;
    }

    public static KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (attributeDefinitionService == null) {
            attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return attributeDefinitionService;
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NaturalLanguageTemplateBo();
    }

    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "attributeBos") {
            return this.attributeBos;
        }
        if (string == "naturalLanguageUsageId") {
            return this.naturalLanguageUsageId;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "languageCode") {
            return this.languageCode;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (String)object;
            return;
        }
        if (string == "attributeBos") {
            this.attributeBos = (Set)object;
            return;
        }
        if (string == "naturalLanguageUsageId") {
            this.naturalLanguageUsageId = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "languageCode") {
            this.languageCode = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public String _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(String string) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_propertyChange("template", this.template, string);
        this.template = string;
    }

    public Set _persistence_get_attributeBos() {
        this._persistence_checkFetched("attributeBos");
        return this.attributeBos;
    }

    public void _persistence_set_attributeBos(Set set) {
        this._persistence_checkFetchedForSet("attributeBos");
        this._persistence_propertyChange("attributeBos", this.attributeBos, set);
        this.attributeBos = set;
    }

    public String _persistence_get_naturalLanguageUsageId() {
        this._persistence_checkFetched("naturalLanguageUsageId");
        return this.naturalLanguageUsageId;
    }

    public void _persistence_set_naturalLanguageUsageId(String string) {
        this._persistence_checkFetchedForSet("naturalLanguageUsageId");
        this._persistence_propertyChange("naturalLanguageUsageId", this.naturalLanguageUsageId, string);
        this.naturalLanguageUsageId = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, string);
        this.typeId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_languageCode() {
        this._persistence_checkFetched("languageCode");
        return this.languageCode;
    }

    public void _persistence_set_languageCode(String string) {
        this._persistence_checkFetchedForSet("languageCode");
        this._persistence_propertyChange("languageCode", this.languageCode, string);
        this.languageCode = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

