/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.print;

import java.util.Map;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrint;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="questionnairePrintingService")
public class QuestionnairePrintingServiceImpl
implements QuestionnairePrintingService {
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    @Autowired
    @Qualifier(value="questionnairePrint")
    private QuestionnairePrint questionnairePrint;

    @Override
    public AttachmentDataSource printQuestionnaire(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setName("Questionnaire-" + reportParameters.get("documentNumber") + ".pdf");
            source.setType("application/pdf");
        }
        return source;
    }

    @Override
    public AttachmentDataSource printQuestionnaireAnswer(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setName("QuestionnaireAnswer" + reportParameters.get("id") + ".pdf");
            source.setType("application/pdf");
        }
        return source;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public QuestionnairePrint getQuestionnairePrint() {
        return this.questionnairePrint;
    }

    public void setQuestionnairePrint(QuestionnairePrint questionnairePrint) {
        this.questionnairePrint = questionnairePrint;
    }
}

