/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.BudgetContainer;
import org.kuali.coeus.common.budget.framework.income.BudgetPeriodIncomeTotal;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.notification.impl.NotificationAwareForm;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.AddBudgetDto;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.budget.core.SelectableBudget;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetChangedData;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularSummary;
import org.kuali.coeus.propdev.impl.budget.nonpersonnel.AddProjectBudgetLineItemHelper;
import org.kuali.coeus.propdev.impl.budget.person.AddProjectPersonnelHelper;
import org.kuali.coeus.propdev.impl.core.AddLineHelper;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.Auditable;
import org.kuali.coeus.sys.impl.validation.DataValidationItem;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.ToggleMenu;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ProposalBudgetForm
extends UifFormBase
implements BudgetContainer,
Auditable,
SelectableBudget,
NotificationAwareForm<ProposalDevelopmentNotificationContext> {
    private ProposalDevelopmentBudgetExt budget;
    private String defaultBudgetPeriodWarningMessage;
    private Map<String, List<String>> editableBudgetLineItems;
    private AddProjectPersonnelHelper addProjectPersonnelHelper;
    private AddBudgetDto addBudgetDto;
    private AddBudgetDto copyBudgetDto;
    private AddProjectBudgetLineItemHelper addProjectBudgetLineItemHelper;
    private BudgetJustificationWrapper budgetJustificationWrapper;
    private BudgetModularSummary budgetModularSummary;
    private ProposalDevelopmentBudgetExt selectedBudget;
    private boolean auditActivated;
    private List<DataValidationItem> dataValidationItems;
    private boolean viewOnly = false;
    private List<DevelopmentProposal> hierarchyDevelopmentProposals;
    private boolean submitBudgetIndicator;
    private BudgetChangedData newBudgetChangedData;
    private NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper;
    private boolean sendOverrideNotification;
    private AddLineHelper addRecipientHelper;
    private MessageMap deferredMessages;

    public void initialize() {
        this.editableBudgetLineItems = new HashMap<String, List<String>>();
        this.addProjectPersonnelHelper = new AddProjectPersonnelHelper();
        this.addProjectBudgetLineItemHelper = new AddProjectBudgetLineItemHelper();
        this.budgetJustificationWrapper = new BudgetJustificationWrapper(this.budget != null ? this.budget.getBudgetJustification() : "");
        this.dataValidationItems = new ArrayList<DataValidationItem>();
        this.newBudgetChangedData = new BudgetChangedData();
        this.notificationHelper = new NotificationHelper();
        this.addRecipientHelper = new AddLineHelper();
    }

    @Override
    public ProposalDevelopmentBudgetExt getBudget() {
        return this.budget;
    }

    public void setBudget(ProposalDevelopmentBudgetExt budget) {
        this.budget = budget;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.getBudget().getDevelopmentProposal();
    }

    @Override
    public Document getDocument() {
        return this.getDevelopmentProposal().getProposalDocument();
    }

    public List<Action> getOrderedNavigationActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.addAllActions(actions, this.view.getNavigation().getItems());
        return actions;
    }

    protected void addAllActions(List<Action> actionList, List<? extends Component> components) {
        for (Component component : components) {
            Action action;
            if (component instanceof ToggleMenu) {
                this.addAllActions(actionList, ((ToggleMenu)component).getMenuItems());
                continue;
            }
            if (!(component instanceof Action) || StringUtils.equals((CharSequence)(action = (Action)component).getId(), (CharSequence)"PropBudget-Menu-ReturnToProposal")) continue;
            actionList.add(action);
        }
    }

    public String getDefaultBudgetPeriodWarningMessage() {
        return this.defaultBudgetPeriodWarningMessage;
    }

    public void setDefaultBudgetPeriodWarningMessage(String defaultBudgetPeriodWarningMessage) {
        this.defaultBudgetPeriodWarningMessage = defaultBudgetPeriodWarningMessage;
    }

    public Map<String, List<String>> getEditableBudgetLineItems() {
        return this.editableBudgetLineItems;
    }

    public void setEditableBudgetLineItems(Map<String, List<String>> editableBudgetLineItems) {
        this.editableBudgetLineItems = editableBudgetLineItems;
    }

    public AddProjectPersonnelHelper getAddProjectPersonnelHelper() {
        return this.addProjectPersonnelHelper;
    }

    public void setAddProjectPersonnelHelper(AddProjectPersonnelHelper addProjectPersonnelHelper) {
        this.addProjectPersonnelHelper = addProjectPersonnelHelper;
    }

    public AddBudgetDto getAddBudgetDto() {
        return this.addBudgetDto;
    }

    public void setAddBudgetDto(AddBudgetDto addBudgetDto) {
        this.addBudgetDto = addBudgetDto;
    }

    public AddBudgetDto getCopyBudgetDto() {
        return this.copyBudgetDto;
    }

    public void setCopyBudgetDto(AddBudgetDto copyBudgetDto) {
        this.copyBudgetDto = copyBudgetDto;
    }

    public List<BudgetPeriodIncomeTotal> getBudgetPeriodIncomeTotalSummary() {
        ArrayList<BudgetPeriodIncomeTotal> budgetPeriodIncomeTotalSummary = new ArrayList<BudgetPeriodIncomeTotal>();
        Map<Integer, ScaleTwoDecimal> periodTotalMap = this.getBudget().mapProjectIncomeTotalsToBudgetPeriodNumbers();
        for (Map.Entry<Integer, ScaleTwoDecimal> entry : periodTotalMap.entrySet()) {
            budgetPeriodIncomeTotalSummary.add(new BudgetPeriodIncomeTotal(entry.getKey(), entry.getValue()));
        }
        return budgetPeriodIncomeTotalSummary;
    }

    public Date getLineItemStartDate(BudgetLineItem lineItem) {
        if (CollectionUtils.isNotEmpty(lineItem.getBudgetPersonnelDetailsList())) {
            List personnelDetailsWithDifferentDates = lineItem.getBudgetPersonnelDetailsList().stream().filter(budgetPersonnelDetails -> budgetPersonnelDetails.getStartDate() == null || lineItem.getBudgetPersonnelDetailsList().get(0).getStartDate() == null || budgetPersonnelDetails.getStartDate().compareTo(lineItem.getBudgetPersonnelDetailsList().get(0).getStartDate()) != 0).collect(Collectors.toList());
            return personnelDetailsWithDifferentDates.isEmpty() ? lineItem.getBudgetPersonnelDetails(0).getStartDate() : lineItem.getStartDate();
        }
        return lineItem.getStartDate();
    }

    public Date getLineItemEndDate(BudgetLineItem lineItem) {
        if (CollectionUtils.isNotEmpty(lineItem.getBudgetPersonnelDetailsList())) {
            List personnelDetailsWithDifferentDates = lineItem.getBudgetPersonnelDetailsList().stream().filter(budgetPersonnelDetails -> budgetPersonnelDetails.getEndDate() == null || lineItem.getBudgetPersonnelDetailsList().get(0).getEndDate() == null || budgetPersonnelDetails.getEndDate().compareTo(lineItem.getBudgetPersonnelDetailsList().get(0).getEndDate()) != 0).collect(Collectors.toList());
            return personnelDetailsWithDifferentDates.isEmpty() ? lineItem.getBudgetPersonnelDetails(0).getEndDate() : lineItem.getEndDate();
        }
        return lineItem.getEndDate();
    }

    public boolean isUnrecoveredFandAEditFormVisible() {
        return this.budget != null && this.budget.isUnrecoveredFandAApplicable() != false && this.budget.isUnrecoveredFandAAvailable();
    }

    public boolean isCostSharingEditFormVisible() {
        return this.budget != null && this.budget.isCostSharingApplicable() != false && this.budget.isCostSharingAvailable();
    }

    public AddProjectBudgetLineItemHelper getAddProjectBudgetLineItemHelper() {
        return this.addProjectBudgetLineItemHelper;
    }

    public void setAddProjectBudgetLineItemHelper(AddProjectBudgetLineItemHelper addProjectBudgetLineItemHelper) {
        this.addProjectBudgetLineItemHelper = addProjectBudgetLineItemHelper;
    }

    public BudgetJustificationWrapper getBudgetJustificationWrapper() {
        return this.budgetJustificationWrapper;
    }

    public void setBudgetJustificationWrapper(BudgetJustificationWrapper budgetJustificationWrapper) {
        this.budgetJustificationWrapper = budgetJustificationWrapper;
    }

    public void setBudgetModularSummary(BudgetModularSummary budgetModularSummary) {
        this.budgetModularSummary = budgetModularSummary;
    }

    public BudgetModularSummary getBudgetModularSummary() {
        return this.budgetModularSummary;
    }

    @Override
    public ProposalDevelopmentBudgetExt getSelectedBudget() {
        return this.selectedBudget;
    }

    @Override
    public void setSelectedBudget(ProposalDevelopmentBudgetExt selectedBudget) {
        this.selectedBudget = selectedBudget;
    }

    @Override
    public boolean isAuditActivated() {
        return this.auditActivated;
    }

    @Override
    public void setAuditActivated(boolean auditActivated) {
        this.auditActivated = auditActivated;
    }

    public List<DataValidationItem> getDataValidationItems() {
        return this.dataValidationItems;
    }

    public void setDataValidationItems(List<DataValidationItem> dataValidationItems) {
        this.dataValidationItems = dataValidationItems;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public List<DevelopmentProposal> getHierarchyDevelopmentProposals() {
        return this.hierarchyDevelopmentProposals;
    }

    public void setHierarchyDevelopmentProposals(List<DevelopmentProposal> hierarchyDevelopmentProposals) {
        this.hierarchyDevelopmentProposals = hierarchyDevelopmentProposals;
    }

    public boolean isSubmitBudgetIndicator() {
        return this.submitBudgetIndicator;
    }

    public void setSubmitBudgetIndicator(boolean submitBudgetIndicator) {
        this.submitBudgetIndicator = submitBudgetIndicator;
    }

    public BudgetChangedData getNewBudgetChangedData() {
        return this.newBudgetChangedData;
    }

    public void setNewBudgetChangedData(BudgetChangedData newBudgetChangedData) {
        this.newBudgetChangedData = newBudgetChangedData;
    }

    @Override
    public NotificationHelper<ProposalDevelopmentNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<ProposalDevelopmentNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public boolean isSendOverrideNotification() {
        return this.sendOverrideNotification;
    }

    public void setSendOverrideNotification(boolean proposalChangedDataSendNotification) {
        this.sendOverrideNotification = proposalChangedDataSendNotification;
    }

    @Override
    public AddLineHelper getAddRecipientHelper() {
        return this.addRecipientHelper;
    }

    @Override
    public boolean isSendNotification() {
        return this.isSendOverrideNotification();
    }

    @Override
    public void setSendNotification(boolean sendNotification) {
        this.setSendOverrideNotification(sendNotification);
    }

    public void setAddRecipientHelper(AddLineHelper addRecipientHelper) {
        this.addRecipientHelper = addRecipientHelper;
    }

    @Override
    public MessageMap getDeferredMessages() {
        return this.deferredMessages;
    }

    @Override
    public void setDeferredMessages(MessageMap deferredMessages) {
        this.deferredMessages = deferredMessages;
    }

    public boolean isProposalDevelopmentDocumentLocked() {
        this.getBudget().getDevelopmentProposal().getProposalDocument().refreshPessimisticLocks();
        List proposalDevelopmentLocks = this.getBudget().getDevelopmentProposal().getProposalDocument().getPessimisticLocks();
        Person user = this.getGlobalVariableService().getUserSession().getPerson();
        for (PessimisticLock lock : proposalDevelopmentLocks) {
            String lockRegion;
            String string = lockRegion = lock.getLockDescriptor() != null ? StringUtils.split((String)lock.getLockDescriptor(), (String)"-")[1] : null;
            if (lock.isOwnedByUser(user) || !StringUtils.equals((CharSequence)lockRegion, (CharSequence)"PROPOSAL DEVELOPMENT")) continue;
            return true;
        }
        return false;
    }

    public GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }

    public boolean isCanEdit() {
        if (this.isCanEditView() == null) {
            return false;
        }
        return this.isCanEditView();
    }

    public boolean isLazyLoadBudgetPersonnel() {
        return ((ProposalBudgetViewHelperServiceImpl)this.getViewHelperService()).lazyLoadBudgetPersonnel(this.budget);
    }
}

