/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PBPoolInfo;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactoryDefaultImpl
extends PersistenceBrokerFactoryBaseImpl {
    private static Logger log = LoggerFactory.getLogger(PersistenceBrokerFactoryDefaultImpl.class);
    private GenericKeyedObjectPool brokerPool;
    private PBPoolInfo poolConfig = new PBPoolInfo();

    public PersistenceBrokerFactoryDefaultImpl() {
        this.brokerPool = this.createPool();
        log.info("Create PersistenceBroker instance pool, pool configuration was " + this.getPoolConfiguration());
    }

    @Override
    public PersistenceBrokerInternal createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pBKey);
        }
        PersistenceBrokerInternal persistenceBrokerInternal = null;
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        try {
            persistenceBrokerInternal = (PersistenceBrokerInternal)this.brokerPool.borrowObject((Object)pBKey);
            persistenceBrokerInternal = this.wrapRequestedBrokerInstance(persistenceBrokerInternal);
        }
        catch (Exception exception) {
            try {
                if (persistenceBrokerInternal != null) {
                    persistenceBrokerInternal.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pBKey, exception);
        }
        return persistenceBrokerInternal;
    }

    protected PersistenceBrokerInternal wrapBrokerWithPoolingHandle(PersistenceBrokerInternal persistenceBrokerInternal, KeyedObjectPool keyedObjectPool) {
        return new PoolablePersistenceBroker(persistenceBrokerInternal, keyedObjectPool);
    }

    protected PersistenceBrokerInternal wrapRequestedBrokerInstance(PersistenceBrokerInternal persistenceBrokerInternal) {
        return new PersistenceBrokerHandle(persistenceBrokerInternal);
    }

    @Override
    public synchronized void releaseAllInstances() {
        log.warn("Release all instances referenced by this object");
        super.releaseAllInstances();
        try {
            this.brokerPool.close();
            this.brokerPool = this.createPool();
        }
        catch (Exception exception) {
            log.error("Error while release all pooled broker instances and refresh pool", exception);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.brokerPool.close();
            this.brokerPool = null;
        }
        catch (Exception exception) {
            log.error("Error while shutdown of broker pool", exception);
        }
        super.shutdown();
    }

    @Override
    public int activePersistenceBroker() {
        return this.brokerPool.getNumActive();
    }

    public Properties getPoolConfiguration() {
        return this.poolConfig;
    }

    public void setPoolConfiguration(Properties properties) {
        this.poolConfig = new PBPoolInfo(properties);
        log.info("Change pooling configuration properties: " + this.poolConfig.getKeyedObjectPoolConfig());
        this.brokerPool.setConfig(this.poolConfig.getKeyedObjectPoolConfig());
    }

    private GenericKeyedObjectPool createPool() {
        GenericKeyedObjectPool.Config config = this.poolConfig.getKeyedObjectPoolConfig();
        if (log.isDebugEnabled()) {
            log.debug("PersistenceBroker pool will be setup with the following configuration " + ToStringBuilder.reflectionToString((Object)config, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        }
        GenericKeyedObjectPool genericKeyedObjectPool = new GenericKeyedObjectPool(null, config);
        genericKeyedObjectPool.setFactory((KeyedPoolableObjectFactory)new PBKeyedPoolableObjectFactory(this, (KeyedObjectPool)genericKeyedObjectPool));
        return genericKeyedObjectPool;
    }

    class PBKeyedPoolableObjectFactory
    implements KeyedPoolableObjectFactory {
        private PersistenceBrokerFactoryDefaultImpl pbf;
        private KeyedObjectPool pool;

        public PBKeyedPoolableObjectFactory(PersistenceBrokerFactoryDefaultImpl persistenceBrokerFactoryDefaultImpl2, KeyedObjectPool keyedObjectPool) {
            this.pbf = persistenceBrokerFactoryDefaultImpl2;
            this.pool = keyedObjectPool;
        }

        public Object makeObject(Object object) throws Exception {
            return PersistenceBrokerFactoryDefaultImpl.this.wrapBrokerWithPoolingHandle(this.pbf.createNewBrokerInstance((PBKey)object), this.pool);
        }

        public void destroyObject(Object object, Object object2) throws Exception {
            PoolablePersistenceBroker poolablePersistenceBroker = (PoolablePersistenceBroker)object2;
            PersistenceBroker persistenceBroker = poolablePersistenceBroker.getInnermostDelegate();
            if (persistenceBroker instanceof PersistenceBrokerImpl) {
                log.info("Destroy PersistenceBroker instance " + object2);
                ((PersistenceBrokerImpl)persistenceBroker).destroy();
            }
            poolablePersistenceBroker.destroy();
        }

        public boolean validateObject(Object object, Object object2) {
            if (((PersistenceBroker)object2).isInTransaction()) {
                log.error("Illegal broker state! This broker instance was already in transaction.");
                return false;
            }
            return true;
        }

        public void activateObject(Object object, Object object2) throws Exception {
            ((PBState)object2).setClosed(false);
        }

        public void passivateObject(Object object, Object object2) throws Exception {
            ((PBState)object2).setClosed(true);
        }
    }
}

