/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;

public class ManageableHashMap
extends HashMap
implements ManageableCollection {
    @Override
    public void ojbAdd(Object object) {
        if (object != null) {
            ClassDescriptor classDescriptor = MetadataManager.getInstance().getRepository().getDescriptorFor(object.getClass());
            FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
            if (fieldDescriptorArray.length > 1 || fieldDescriptorArray.length == 0) {
                throw new MetadataException("ManageableHashMap can only be used for persistence capable objects with exactly one primiary key field defined in metadata, for " + object.getClass() + " the" + " PK field count is " + fieldDescriptorArray.length);
            }
            Object object2 = fieldDescriptorArray[0].getPersistentField().get(object);
            this.put(object2, object);
        }
    }

    @Override
    public void ojbAddAll(ManageableCollection manageableCollection) {
        Iterator iterator = manageableCollection.ojbIterator();
        while (iterator.hasNext()) {
            this.ojbAdd(iterator.next());
        }
    }

    @Override
    public Iterator ojbIterator() {
        return this.values().iterator();
    }

    @Override
    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }
}

