/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.copy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.IdentityMapFactory;
import org.apache.ojb.otm.copy.ObjectCopyException;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.SerializeObjectCopyStrategy;

public final class ReflectiveObjectCopyStrategy
implements ObjectCopyStrategy {
    private static final Set FINAL_IMMUTABLE_CLASSES;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final SerializeObjectCopyStrategy _serialize;

    @Override
    public final Object copy(Object object, PersistenceBroker persistenceBroker) {
        return ReflectiveObjectCopyStrategy.clone(object, IdentityMapFactory.getIdentityMap(), new HashMap());
    }

    private static Object clone(Object object, Map map, Map map2) {
        Object object2;
        if (map.containsKey(object)) {
            return map.get(object);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            object2 = ReflectiveObjectCopyStrategy.handleArray(object, map, clazz, map2);
        } else if (FINAL_IMMUTABLE_CLASSES.contains(clazz)) {
            map.put(object, object);
            object2 = object;
        } else {
            object2 = ReflectiveObjectCopyStrategy.handleObjectWithNoArgsConstructor(map2, clazz, map, object);
        }
        return object2;
    }

    private static Object handleObjectWithNoArgsConstructor(Map map, Class clazz, Map map2, Object object) {
        Object object2 = null;
        ClassMetadata classMetadata = (ClassMetadata)map.get(clazz);
        if (classMetadata == null) {
            classMetadata = new ClassMetadata();
            map.put(clazz, classMetadata);
        }
        Constructor constructor = classMetadata.m_noArgConstructor;
        if (classMetadata.m_hasNoArgConstructor && constructor == null) {
            try {
                classMetadata.m_noArgConstructor = constructor = clazz.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (Exception exception) {
                classMetadata.m_hasNoArgConstructor = false;
            }
        }
        if (classMetadata.m_hasNoArgConstructor) {
            if (!classMetadata.m_noArgConstructorAccessible && (1 & constructor.getModifiers()) == 0) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new ObjectCopyException("cannot access noArg constructor [" + constructor + "] of class [" + clazz.getName() + "]: " + securityException.toString(), securityException);
                }
                classMetadata.m_noArgConstructorAccessible = true;
            }
            try {
                object2 = constructor.newInstance(EMPTY_OBJECT_ARRAY);
                map2.put(object, object2);
            }
            catch (Exception exception) {
                throw new ObjectCopyException("cannot instantiate class [" + clazz.getName() + "] using noArg constructor: " + exception.toString(), exception);
            }
            for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                ReflectiveObjectCopyStrategy.copyClass(map, clazz2, object, object2, map2);
            }
        } else {
            object2 = _serialize.copy(object, null);
        }
        return object2;
    }

    private static void copyClass(Map map, Class clazz, Object object, Object object2, Map map2) {
        Field[] fieldArray;
        ClassMetadata classMetadata = (ClassMetadata)map.get(clazz);
        if (classMetadata == null) {
            classMetadata = new ClassMetadata();
            map.put(clazz, classMetadata);
        }
        if ((fieldArray = classMetadata.m_declaredFields) == null) {
            fieldArray = clazz.getDeclaredFields();
            classMetadata.m_declaredFields = fieldArray;
        }
        ReflectiveObjectCopyStrategy.setFields(object, object2, fieldArray, classMetadata.m_fieldsAccessible, map2, map);
        classMetadata.m_fieldsAccessible = true;
    }

    private static Object handleArray(Object object, Map map, Class clazz, Map map2) {
        Object object2;
        int n = Array.getLength(object);
        if (n == 0) {
            map.put(object, object);
            object2 = object;
        } else {
            Class<?> clazz2 = clazz.getComponentType();
            object2 = Array.newInstance(clazz2, n);
            map.put(object, object2);
            if (clazz2.isPrimitive() || FINAL_IMMUTABLE_CLASSES.contains(clazz2)) {
                System.arraycopy(object, 0, object2, 0, n);
            } else {
                for (int i = 0; i < n; ++i) {
                    Object object3 = Array.get(object, i);
                    if (object3 == null) continue;
                    Object object4 = ReflectiveObjectCopyStrategy.clone(object3, map, map2);
                    Array.set(object2, i, object4);
                }
            }
        }
        return object2;
    }

    private static void setFields(Object object, Object object2, Field[] fieldArray, boolean bl, Map map, Map map2) {
        for (Field field : fieldArray) {
            int n = field.getModifiers();
            if ((8 & n) != 0) continue;
            if ((0x10 & n) != 0) {
                throw new ObjectCopyException("cannot set final field [" + field.getName() + "] of class [" + object.getClass().getName() + "]");
            }
            if (!bl && (1 & n) == 0) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new ObjectCopyException("cannot access field [" + field.getName() + "] of class [" + object.getClass().getName() + "]: " + securityException.toString(), securityException);
                }
            }
            try {
                ReflectiveObjectCopyStrategy.cloneAndSetFieldValue(field, object, object2, map, map2);
            }
            catch (Exception exception) {
                throw new ObjectCopyException("cannot set field [" + field.getName() + "] of class [" + object.getClass().getName() + "]: " + exception.toString(), exception);
            }
        }
    }

    private static void cloneAndSetFieldValue(Field field, Object object, Object object2, Map map, Map map2) throws IllegalAccessException {
        Object object3 = field.get(object);
        if (object3 == null) {
            field.set(object2, null);
        } else {
            Class<?> clazz = object3.getClass();
            if (!clazz.isPrimitive() && !FINAL_IMMUTABLE_CLASSES.contains(clazz)) {
                object3 = ReflectiveObjectCopyStrategy.clone(object3, map, map2);
            }
            field.set(object2, object3);
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
        _serialize = new SerializeObjectCopyStrategy();
        FINAL_IMMUTABLE_CLASSES = new HashSet(17);
        FINAL_IMMUTABLE_CLASSES.add(String.class);
        FINAL_IMMUTABLE_CLASSES.add(Byte.class);
        FINAL_IMMUTABLE_CLASSES.add(Short.class);
        FINAL_IMMUTABLE_CLASSES.add(Integer.class);
        FINAL_IMMUTABLE_CLASSES.add(Long.class);
        FINAL_IMMUTABLE_CLASSES.add(Float.class);
        FINAL_IMMUTABLE_CLASSES.add(Double.class);
        FINAL_IMMUTABLE_CLASSES.add(Character.class);
        FINAL_IMMUTABLE_CLASSES.add(Boolean.class);
    }

    private static final class ClassMetadata {
        Constructor m_noArgConstructor;
        Field[] m_declaredFields;
        boolean m_noArgConstructorAccessible;
        boolean m_fieldsAccessible;
        boolean m_hasNoArgConstructor = true;

        private ClassMetadata() {
        }
    }
}

