/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionTimeoutTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(TransactionTimeoutTask.class);
    private final BitronixTransaction transaction;

    public TransactionTimeoutTask(BitronixTransaction transaction, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.transaction = transaction;
    }

    public Object getObject() {
        return this.transaction;
    }

    public void execute() throws TaskException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("marking " + this.transaction + " as timed out");
            }
            this.transaction.timeout();
        }
        catch (BitronixSystemException ex) {
            throw new TaskException("failed to timeout " + this.transaction, (Throwable)((Object)ex));
        }
    }

    public String toString() {
        return "a TransactionTimeoutTask on " + this.transaction + " scheduled for " + this.getExecutionTime();
    }
}

