/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectCollectionSortAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataConfigurationException;
import org.kuali.rice.krad.data.metadata.MetadataMergeAction;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeRelationshipImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectCollectionImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectCollectionSortAttributeImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectMetadataImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectRelationshipImpl;
import org.kuali.rice.krad.data.metadata.impl.MetadataCommonBase;
import org.kuali.rice.krad.data.provider.annotation.AttributeRelationship;
import org.kuali.rice.krad.data.provider.annotation.BusinessKey;
import org.kuali.rice.krad.data.provider.annotation.CollectionRelationship;
import org.kuali.rice.krad.data.provider.annotation.CollectionSortAttribute;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.ForceUppercase;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.MergeAction;
import org.kuali.rice.krad.data.provider.annotation.NonPersistentProperty;
import org.kuali.rice.krad.data.provider.annotation.PropertyEditorClass;
import org.kuali.rice.krad.data.provider.annotation.ReadOnly;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.Sensitive;
import org.kuali.rice.krad.data.provider.annotation.ShortLabel;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;
import org.kuali.rice.krad.data.provider.impl.MetadataProviderBase;

public class AnnotationMetadataProviderImpl
extends MetadataProviderBase {
    private static final Logger LOG = LogManager.getLogger(AnnotationMetadataProviderImpl.class);
    private boolean initializationAttempted = false;
    private DataObjectService dataObjectService;

    @Override
    protected void initializeMetadata(Collection<Class<?>> types) {
        if (this.initializationAttempted) {
            return;
        }
        this.initializationAttempted = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing annotations for the given list of data objects: " + types);
        }
        if (types == null || types.isEmpty()) {
            LOG.warn(this.getClass().getSimpleName() + " was passed an empty list of types to initialize, doing nothing");
            return;
        }
        LOG.info("Started Scanning For Metadata Annotations");
        for (Class<?> type : types) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Annotations on : " + type);
            }
            boolean annotationsFound = false;
            DataObjectMetadataImpl metadata = new DataObjectMetadataImpl();
            metadata.setProviderName(this.getClass().getSimpleName());
            metadata.setType(type);
            annotationsFound |= this.processClassLevelAnnotations(type, metadata);
            annotationsFound |= this.processFieldLevelAnnotations(type, metadata);
            annotationsFound |= this.processMethodLevelAnnotations(type, metadata);
            if (!(annotationsFound |= this.processInheritedAttributes(type, metadata))) continue;
            this.masterMetadataMap.put(type, metadata);
        }
        LOG.info("Completed Scanning For Metadata Annotations");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotation Metadata: " + this.masterMetadataMap);
        }
    }

    protected boolean processClassLevelAnnotations(Class<?> clazz, DataObjectMetadataImpl metadata) {
        boolean classAnnotationFound = false;
        boolean fieldAnnotationsFound = false;
        ArrayList<DataObjectAttribute> attributes = new ArrayList<DataObjectAttribute>(metadata.getAttributes());
        Annotation[] classAnnotations = clazz.getAnnotations();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class-level annotations: " + Arrays.asList(classAnnotations));
        }
        for (Annotation a : classAnnotations) {
            if (this.processAnnotationsforCommonMetadata(a, metadata)) {
                classAnnotationFound = true;
                continue;
            }
            if (a instanceof MergeAction) {
                MetadataMergeAction mma = ((MergeAction)a).value();
                if (mma != MetadataMergeAction.MERGE && mma != MetadataMergeAction.REMOVE) {
                    throw new MetadataConfigurationException("Only the MERGE and REMOVE merge actions are supported since the annotation metadata provider can not specify all required properties and may only be used as an overlay.");
                }
                metadata.setMergeAction(mma);
                classAnnotationFound = true;
                continue;
            }
            if (!(a instanceof UifAutoCreateViews)) continue;
            metadata.setAutoCreateUifViewTypes(Arrays.asList(((UifAutoCreateViews)a).value()));
            classAnnotationFound = true;
        }
        if (fieldAnnotationsFound) {
            metadata.setAttributes(attributes);
        }
        return classAnnotationFound;
    }

    protected boolean processFieldLevelAnnotations(Class<?> clazz, DataObjectMetadataImpl metadata) {
        boolean fieldAnnotationsFound = false;
        boolean additionalClassAnnotationsFound = false;
        ArrayList<DataObjectAttribute> attributes = new ArrayList<DataObjectAttribute>();
        for (Field f : clazz.getDeclaredFields()) {
            boolean existingAttribute;
            boolean fieldAnnotationFound = false;
            String propertyName = f.getName();
            DataObjectAttributeImpl attr = (DataObjectAttributeImpl)metadata.getAttribute(propertyName);
            boolean bl = existingAttribute = attr != null;
            if (!existingAttribute) {
                attr = new DataObjectAttributeImpl();
                attr.setName(propertyName);
                attr.setType(f.getType());
                DataType dataType = DataType.getDataTypeFromClass(f.getType());
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                attr.setDataType(dataType);
                attr.setOwningType(metadata.getType());
            }
            Annotation[] fieldAnnotations = f.getDeclaredAnnotations();
            if (LOG.isDebugEnabled()) {
                LOG.debug(f.getDeclaringClass() + "." + f.getName() + " Field-level annotations: " + Arrays.asList(fieldAnnotations));
            }
            for (Annotation a : fieldAnnotations) {
                if (fieldAnnotationFound |= this.processAnnotationForAttribute(a, attr, metadata)) continue;
                if (a instanceof BusinessKey) {
                    ArrayList<String> businessKeys = new ArrayList<String>(metadata.getBusinessKeyAttributeNames());
                    businessKeys.add(f.getName());
                    metadata.setBusinessKeyAttributeNames(businessKeys);
                    additionalClassAnnotationsFound = true;
                    continue;
                }
                if (a instanceof Relationship) {
                    this.addDataObjectRelationship(metadata, f, (Relationship)a);
                    additionalClassAnnotationsFound = true;
                    continue;
                }
                if (!(a instanceof CollectionRelationship)) continue;
                this.addDataObjectCollection(metadata, f, (CollectionRelationship)a);
                additionalClassAnnotationsFound = true;
            }
            if (!fieldAnnotationFound) continue;
            attributes.add(attr);
            fieldAnnotationsFound = true;
        }
        if (fieldAnnotationsFound) {
            metadata.setAttributes(attributes);
        }
        return fieldAnnotationsFound || additionalClassAnnotationsFound;
    }

    protected boolean processAnnotationsforCommonMetadata(Annotation a, MetadataCommonBase metadata) {
        if (a instanceof Label && StringUtils.isNotBlank((String)((Label)a).value())) {
            metadata.setLabel(((Label)a).value());
            return true;
        }
        if (a instanceof ShortLabel) {
            metadata.setShortLabel(((ShortLabel)a).value());
            return true;
        }
        if (a instanceof Description) {
            metadata.setDescription(((Description)a).value());
            return true;
        }
        return false;
    }

    protected boolean processAnnotationForAttribute(Annotation a, DataObjectAttributeImpl attr, DataObjectMetadataImpl metadata) {
        if (a == null) {
            return false;
        }
        if (a instanceof NonPersistentProperty) {
            attr.setPersisted(false);
            return true;
        }
        if (this.processAnnotationsforCommonMetadata(a, attr)) {
            return true;
        }
        if (a instanceof ReadOnly) {
            attr.setReadOnly(true);
            return true;
        }
        if (a instanceof UifValidCharactersConstraintBeanName) {
            attr.setValidCharactersConstraintBeanName(((UifValidCharactersConstraintBeanName)a).value());
            return true;
        }
        if (a instanceof KeyValuesFinderClass) {
            try {
                attr.setValidValues(((KeyValuesFinderClass)a).value().newInstance());
                return true;
            }
            catch (Exception ex) {
                LOG.error("Unable to instantiate options finder: " + ((KeyValuesFinderClass)a).value(), (Throwable)ex);
            }
        }
        if (a instanceof NotNull) {
            attr.setRequired(true);
            return true;
        }
        if (a instanceof ForceUppercase) {
            attr.setForceUppercase(true);
            return true;
        }
        if (a instanceof PropertyEditorClass) {
            try {
                attr.setPropertyEditor(((PropertyEditorClass)a).value().newInstance());
                return true;
            }
            catch (Exception ex) {
                LOG.warn("Unable to instantiate property editor class for " + metadata.getTypeClassName() + "." + attr.getName() + " : " + ((PropertyEditorClass)a).value(), (Throwable)ex);
            }
        }
        if (a instanceof Size && ((Size)a).max() != Integer.MAX_VALUE) {
            attr.setMaxLength(Long.valueOf(((Size)a).max()));
            return true;
        }
        if (a instanceof Sensitive) {
            attr.setSensitive(true);
            return true;
        }
        if (a instanceof UifDisplayHints) {
            attr.setDisplayHints(new HashSet<UifDisplayHint>(Arrays.asList(((UifDisplayHints)a).value())));
            return true;
        }
        if (a instanceof MergeAction) {
            MetadataMergeAction mma = ((MergeAction)a).value();
            if (mma != MetadataMergeAction.MERGE && mma != MetadataMergeAction.REMOVE) {
                throw new MetadataConfigurationException("Only the MERGE and REMOVE merge actions are supported since the annotation metadata provider can not specify all required properties and may only be used as an overlay.");
            }
            attr.setMergeAction(mma);
            return true;
        }
        return false;
    }

    protected String getPropertyNameFromGetterMethod(Method m) {
        String propertyName = "";
        propertyName = m.getName().startsWith("get") ? StringUtils.uncapitalize((String)StringUtils.removeStart((String)m.getName(), (String)"get")) : StringUtils.uncapitalize((String)StringUtils.removeStart((String)m.getName(), (String)"is"));
        return propertyName;
    }

    protected boolean processMethodLevelAnnotations(Class<?> clazz, DataObjectMetadataImpl metadata) {
        boolean fieldAnnotationsFound = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing Method Annotations on " + clazz);
        }
        ArrayList<DataObjectAttribute> attributes = new ArrayList<DataObjectAttribute>(metadata.getAttributes());
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(NonPersistentProperty.class)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Rejecting method " + m.getName() + " because does not have NonPersistentProperty annotation");
                continue;
            }
            if (!m.getName().startsWith("get") && !m.getName().startsWith("is")) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Rejecting method " + m.getName() + " because name does not match getter pattern");
                continue;
            }
            if (m.getReturnType() == null || m.getParameterTypes().length > 0) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Rejecting method " + m.getName() + " because has no return type or has arguments");
                continue;
            }
            String propertyName = this.getPropertyNameFromGetterMethod(m);
            boolean fieldAnnotationFound = false;
            boolean existingAttribute = true;
            DataObjectAttributeImpl attr = (DataObjectAttributeImpl)metadata.getAttribute(propertyName);
            if (attr == null) {
                existingAttribute = false;
                attr = new DataObjectAttributeImpl();
                attr.setName(propertyName);
                attr.setType(m.getReturnType());
                DataType dataType = DataType.getDataTypeFromClass(m.getReturnType());
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                attr.setDataType(dataType);
                attr.setOwningType(metadata.getType());
            }
            Annotation[] methodAnnotations = m.getDeclaredAnnotations();
            if (LOG.isDebugEnabled()) {
                LOG.debug(m.getDeclaringClass() + "." + m.getName() + " Method-level annotations: " + Arrays.asList(methodAnnotations));
            }
            for (Annotation a : methodAnnotations) {
                fieldAnnotationFound |= this.processAnnotationForAttribute(a, attr, metadata);
            }
            if (!fieldAnnotationFound) continue;
            if (!existingAttribute) {
                attributes.add(attr);
            }
            fieldAnnotationsFound = true;
        }
        if (fieldAnnotationsFound) {
            metadata.setAttributes(attributes);
        }
        return fieldAnnotationsFound;
    }

    protected void addDataObjectRelationship(DataObjectMetadataImpl metadata, Field f, Relationship a) {
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>(metadata.getRelationships());
        DataObjectRelationshipImpl relationship = new DataObjectRelationshipImpl();
        relationship.setName(f.getName());
        Class<?> childType = f.getType();
        relationship.setRelatedType(childType);
        relationship.setReadOnly(true);
        relationship.setSavedWithParent(false);
        relationship.setDeletedWithParent(false);
        relationship.setLoadedAtParentLoadTime(false);
        relationship.setLoadedDynamicallyUponUse(true);
        ArrayList<DataObjectAttributeRelationship> attributeRelationships = new ArrayList<DataObjectAttributeRelationship>();
        List<Object> referencePkFields = Collections.emptyList();
        MetadataRepository metadataRepository = this.getDataObjectService().getMetadataRepository();
        if (metadataRepository.contains(childType)) {
            DataObjectMetadata childMetadata = metadataRepository.getMetadata(childType);
            referencePkFields = childMetadata.getPrimaryKeyAttributeNames();
        } else if (f.getType().getName().equals("org.kuali.rice.kim.api.identity.Person")) {
            referencePkFields = Collections.singletonList("principalId");
        }
        if (!referencePkFields.isEmpty()) {
            int index = 0;
            for (String pkField : a.foreignKeyFields()) {
                attributeRelationships.add(new DataObjectAttributeRelationshipImpl(pkField, (String)referencePkFields.get(index)));
                ++index;
            }
            relationship.setAttributeRelationships(attributeRelationships);
            relationships.add(relationship);
        }
        metadata.setRelationships(relationships);
    }

    protected void addDataObjectCollection(DataObjectMetadataImpl metadata, Field f, CollectionRelationship a) {
        ArrayList<DataObjectCollection> collections = new ArrayList<DataObjectCollection>(metadata.getCollections());
        DataObjectCollectionImpl collection = new DataObjectCollectionImpl();
        collection.setName(f.getName());
        if (!Collection.class.isAssignableFrom(f.getType())) {
            throw new IllegalArgumentException("@CollectionRelationship annotations can only be on attributes of Collection type.  Field: " + f.getDeclaringClass().getName() + "." + f.getName() + " (" + f.getType() + ")");
        }
        if (a.collectionElementClass().equals(Object.class)) {
            Type[] genericArgs = ((ParameterizedType)f.getGenericType()).getActualTypeArguments();
            if (genericArgs.length == 0) {
                throw new IllegalArgumentException("You can only leave off the collectionElementClass annotation on a @CollectionRelationship when the Collection type has been <typed>.  Field: " + f.getDeclaringClass().getName() + "." + f.getName() + " (" + f.getType() + ")");
            }
            collection.setRelatedType((Class)genericArgs[0]);
        } else {
            collection.setRelatedType(a.collectionElementClass());
        }
        ArrayList<DataObjectAttributeRelationship> attributeRelationships = new ArrayList<DataObjectAttributeRelationship>(a.attributeRelationships().length);
        for (AttributeRelationship rel : a.attributeRelationships()) {
            attributeRelationships.add(new DataObjectAttributeRelationshipImpl(rel.parentAttributeName(), rel.childAttributeName()));
        }
        collection.setAttributeRelationships(attributeRelationships);
        collection.setReadOnly(false);
        collection.setSavedWithParent(false);
        collection.setDeletedWithParent(false);
        collection.setLoadedAtParentLoadTime(true);
        collection.setLoadedDynamicallyUponUse(false);
        ArrayList<DataObjectCollectionSortAttribute> sortAttributes = new ArrayList<DataObjectCollectionSortAttribute>(a.sortAttributes().length);
        for (CollectionSortAttribute csa : a.sortAttributes()) {
            sortAttributes.add(new DataObjectCollectionSortAttributeImpl(csa.value(), csa.sortDirection()));
        }
        collection.setDefaultCollectionOrderingAttributeNames(sortAttributes);
        collection.setIndirectCollection(a.indirectCollection());
        collection.setMinItemsInCollection(a.minItemsInCollection());
        collection.setMaxItemsInCollection(a.maxItemsInCollection());
        if (StringUtils.isNotBlank((String)a.label())) {
            collection.setLabel(a.label());
        }
        if (StringUtils.isNotBlank((String)a.elementLabel())) {
            collection.setLabel(a.elementLabel());
        }
        collections.add(collection);
        metadata.setCollections(collections);
    }

    protected boolean processInheritedAttributes(Class<?> clazz, DataObjectMetadataImpl metadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing InheritProperties field Annotations on " + clazz);
        }
        ArrayList<DataObjectAttribute> attributes = new ArrayList<DataObjectAttribute>(metadata.getAttributes());
        boolean fieldAnnotationsFound = false;
        for (Field f : clazz.getDeclaredFields()) {
            boolean fieldAnnotationFound = false;
            String propertyName = f.getName();
            if (!f.isAnnotationPresent(InheritProperties.class) && !f.isAnnotationPresent(InheritProperty.class)) continue;
            fieldAnnotationFound = true;
            Object[] propertyList = null;
            InheritProperties a = f.getAnnotation(InheritProperties.class);
            if (a != null) {
                propertyList = a.value();
            } else {
                InheritProperty ip = f.getAnnotation(InheritProperty.class);
                propertyList = new InheritProperty[]{ip};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("InheritProperties found on " + clazz + "." + f.getName() + " : " + Arrays.toString(propertyList));
            }
            for (Object inheritedProperty : propertyList) {
                boolean existingAttribute;
                String inheritedPropertyName = inheritedProperty.name();
                String extendedPropertyName = propertyName + "." + inheritedPropertyName;
                DataObjectAttributeImpl attr = (DataObjectAttributeImpl)metadata.getAttribute(extendedPropertyName);
                boolean bl = existingAttribute = attr != null;
                if (existingAttribute) continue;
                attr = new DataObjectAttributeImpl();
                attr.setName(extendedPropertyName);
                Class<?> relatedClass = f.getType();
                try {
                    attr.setType(this.getTypeOfProperty(relatedClass, inheritedPropertyName));
                    DataType dataType = DataType.getDataTypeFromClass(attr.getType());
                    if (dataType == null) {
                        dataType = DataType.STRING;
                    }
                    attr.setDataType(dataType);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("no field with name " + inheritedPropertyName + " exists on " + relatedClass, e);
                }
                attr.setPersisted(false);
                attr.setOwningType(metadata.getType());
                attr.setInheritedFromType(relatedClass);
                attr.setInheritedFromAttributeName(inheritedPropertyName);
                attr.setInheritedFromParentAttributeName(propertyName);
                this.processAnnotationForAttribute(inheritedProperty.label(), attr, metadata);
                this.processAnnotationForAttribute(inheritedProperty.displayHints(), attr, metadata);
                attributes.add(attr);
            }
            fieldAnnotationsFound |= fieldAnnotationFound;
        }
        if (fieldAnnotationsFound) {
            metadata.setAttributes(attributes);
        }
        return fieldAnnotationsFound;
    }

    protected Class<?> getTypeOfProperty(Class<?> clazz, String propertyName) {
        try {
            Field f = clazz.getField(propertyName);
            return f.getType();
        }
        catch (Exception f) {
            try {
                Method m = clazz.getMethod("get" + StringUtils.capitalize((String)propertyName), new Class[0]);
                return m.getReturnType();
            }
            catch (Exception m) {
                try {
                    Method m2 = clazz.getMethod("is" + StringUtils.capitalize((String)propertyName), new Class[0]);
                    return m2.getReturnType();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    @Override
    public boolean requiresListOfExistingTypes() {
        return true;
    }

    public boolean isInitializationAttempted() {
        return this.initializationAttempted;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

