/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClusterGetSettingsResponse
extends ActionResponse
implements ToXContentObject {
    private Settings persistentSettings = Settings.EMPTY;
    private Settings transientSettings = Settings.EMPTY;
    private Settings defaultSettings = Settings.EMPTY;
    static final String PERSISTENT_FIELD = "persistent";
    static final String TRANSIENT_FIELD = "transient";
    static final String DEFAULTS_FIELD = "defaults";
    private static final ConstructingObjectParser<ClusterGetSettingsResponse, Void> PARSER = new ConstructingObjectParser("cluster_get_settings_response", true, a -> {
        Settings defaultSettings = a[2] == null ? Settings.EMPTY : (Settings)a[2];
        return new ClusterGetSettingsResponse((Settings)a[0], (Settings)a[1], defaultSettings);
    });

    public ClusterGetSettingsResponse(Settings persistentSettings, Settings transientSettings, Settings defaultSettings) {
        if (persistentSettings != null) {
            this.persistentSettings = persistentSettings;
        }
        if (transientSettings != null) {
            this.transientSettings = transientSettings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    public String getSetting(String setting) {
        if (this.persistentSettings.hasValue(setting)) {
            return this.persistentSettings.get(setting);
        }
        if (this.transientSettings.hasValue(setting)) {
            return this.transientSettings.get(setting);
        }
        if (this.defaultSettings.hasValue(setting)) {
            return this.defaultSettings.get(setting);
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(PERSISTENT_FIELD);
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT_FIELD);
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
        if (!this.defaultSettings.isEmpty()) {
            builder.startObject(DEFAULTS_FIELD);
            this.defaultSettings.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ClusterGetSettingsResponse fromXContent(XContentParser parser) {
        return (ClusterGetSettingsResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterGetSettingsResponse that = (ClusterGetSettingsResponse)o;
        return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings) && Objects.equals(this.defaultSettings, that.defaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.transientSettings, this.persistentSettings, this.defaultSettings);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), new ParseField(PERSISTENT_FIELD, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), new ParseField(TRANSIENT_FIELD, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), new ParseField(DEFAULTS_FIELD, new String[0]));
    }
}

