/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.preferences.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;

public class PreferencesServiceImpl
implements PreferencesService {
    private static final Logger LOG = LogManager.getLogger(PreferencesServiceImpl.class);
    private static Map<String, String> USER_OPTION_KEY_DEFAULT_MAP = new HashMap<String, String>();

    public Preferences getPreferences(String principalId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("start preferences fetch user " + principalId);
        }
        Collection<UserOptions> options = this.getUserOptionService().findByWorkflowUser(principalId);
        HashMap<String, UserOptions> optionMap = new HashMap<String, UserOptions>();
        HashMap<String, String> optionValueMap = new HashMap<String, String>();
        HashMap<String, String> documentTypeNotificationPreferences = new HashMap<String, String>();
        for (UserOptions option : options) {
            if (option.getOptionId().endsWith(".DocumentTypeNotification")) {
                String preferenceName = option.getOptionId();
                preferenceName = StringUtils.substringBeforeLast((String)preferenceName, (String)".DocumentTypeNotification");
                documentTypeNotificationPreferences.put(preferenceName, option.getOptionVal());
                continue;
            }
            optionMap.put(option.getOptionId(), option);
        }
        ConfigurationService kcs = CoreApiServiceLocator.getKualiConfigurationService();
        boolean isSaveRequired = false;
        for (Map.Entry<String, String> entry : USER_OPTION_KEY_DEFAULT_MAP.entrySet()) {
            UserOptions option;
            String optionKey = entry.getKey();
            String defaultValue = kcs.getPropertyValueAsString(entry.getValue());
            if (LOG.isDebugEnabled()) {
                LOG.debug("start fetch option " + optionKey + " user " + principalId);
            }
            if ((option = (UserOptions)optionMap.get(optionKey)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User option '" + optionKey + "' on user " + principalId + " has no stored value.  Preferences will require save.");
                }
                option = new UserOptions();
                option.setWorkflowId(principalId);
                option.setOptionId(optionKey);
                option.setOptionVal(defaultValue);
                optionMap.put(optionKey, option);
                if (!(isSaveRequired || optionKey.equals("USE_OUT_BOX") && !ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue())) {
                    isSaveRequired = true;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("End fetch option " + optionKey + " user " + principalId);
            }
            optionValueMap.put(optionKey, option.getOptionVal());
        }
        return Preferences.Builder.create(optionValueMap, documentTypeNotificationPreferences, (boolean)isSaveRequired).build();
    }

    public void savePreferences(String principalId, Preferences preferences) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("saving preferences user " + principalId);
        }
        this.validate(preferences);
        HashMap<String, String> optionsMap = new HashMap<String, String>(50);
        optionsMap.put("DOCUMENT_STATUS_COLOR_C", preferences.getColorDisapproveCancel());
        optionsMap.put("DOCUMENT_STATUS_COLOR_D", preferences.getColorDisapproved());
        optionsMap.put("DOCUMENT_STATUS_COLOR_A", preferences.getColorApproved());
        optionsMap.put("DOCUMENT_STATUS_COLOR_X", preferences.getColorCanceled());
        optionsMap.put("DOCUMENT_STATUS_COLOR_S", preferences.getColorSaved());
        optionsMap.put("DOCUMENT_STATUS_COLOR_R", preferences.getColorEnroute());
        optionsMap.put("DOCUMENT_STATUS_COLOR_P", preferences.getColorProcessed());
        optionsMap.put("DOCUMENT_STATUS_COLOR_I", preferences.getColorInitiated());
        optionsMap.put("DOCUMENT_STATUS_COLOR_F", preferences.getColorFinal());
        optionsMap.put("DOCUMENT_STATUS_COLOR_E", preferences.getColorException());
        optionsMap.put("REFRESH_RATE", preferences.getRefreshRate().trim());
        optionsMap.put("OPEN_ITEMS_NEW_WINDOW", preferences.getOpenNewWindow());
        optionsMap.put("DOC_TYPE_COL_SHOW_NEW", preferences.getShowDocType());
        optionsMap.put("TITLE_COL_SHOW_NEW", preferences.getShowDocTitle());
        optionsMap.put("ACTION_REQUESTED_COL_SHOW_NEW", preferences.getShowActionRequested());
        optionsMap.put("INITIATOR_COL_SHOW_NEW", preferences.getShowInitiator());
        optionsMap.put("DELEGATOR_COL_SHOW_NEW", preferences.getShowDelegator());
        optionsMap.put("DATE_CREATED_COL_SHOW_NEW", preferences.getShowDateCreated());
        optionsMap.put("DOCUMENT_STATUS_COL_SHOW_NEW", preferences.getShowDocumentStatus());
        optionsMap.put("APP_DOC_STATUS_COL_SHOW_NEW", preferences.getShowAppDocStatus());
        optionsMap.put("WORKGROUP_REQUEST_COL_SHOW_NEW", preferences.getShowWorkgroupRequest());
        optionsMap.put("CLEAR_FYI_COL_SHOW_NEW", preferences.getShowClearFyi());
        optionsMap.put("ACTION_LIST_SIZE_NEW", preferences.getPageSize().trim());
        optionsMap.put("EMAIL_NOTIFICATION", preferences.getEmailNotification());
        optionsMap.put("EMAIL_NOTIFY_PRIMARY", preferences.getNotifyPrimaryDelegation());
        optionsMap.put("EMAIL_NOTIFY_SECONDARY", preferences.getNotifySecondaryDelegation());
        optionsMap.put("DELEGATOR_FILTER", preferences.getDelegatorFilter());
        optionsMap.put("PRIMARY_DELEGATE_FILTER", preferences.getPrimaryDelegateFilter());
        optionsMap.put("LAST_APPROVED_DATE_COL_SHOW_NEW", preferences.getShowDateApproved());
        optionsMap.put("CURRENT_NODE_COL_SHOW_NEW", preferences.getShowCurrentNode());
        optionsMap.put("NOTIFY_ACKNOWLEDGE", preferences.getNotifyAcknowledge());
        optionsMap.put("NOTIFY_APPROVE", preferences.getNotifyApprove());
        optionsMap.put("NOTIFY_COMPLETE", preferences.getNotifyComplete());
        optionsMap.put("NOTIFY_FYI", preferences.getNotifyFYI());
        if (ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue()) {
            optionsMap.put("USE_OUT_BOX", preferences.getUseOutbox());
        }
        for (Map.Entry documentTypePreference : preferences.getDocumentTypeNotificationPreferences().entrySet()) {
            optionsMap.put((String)documentTypePreference.getKey() + ".DocumentTypeNotification", (String)documentTypePreference.getValue());
        }
        this.getUserOptionService().save(principalId, optionsMap);
        Preferences storedPreferences = this.getPreferences(principalId);
        for (Map.Entry storedEntry : storedPreferences.getDocumentTypeNotificationPreferences().entrySet()) {
            if (preferences.getDocumentTypeNotificationPreference((String)storedEntry.getKey()) != null) continue;
            this.getUserOptionService().deleteUserOptions(this.getUserOptionService().findByOptionId((String)storedEntry.getKey() + ".DocumentTypeNotification", principalId));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("saved preferences user " + principalId);
        }
    }

    private void validate(Preferences preferences) {
        LOG.debug("validating preferences");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        try {
            new Integer(preferences.getRefreshRate().trim());
        }
        catch (NumberFormatException e) {
            errors.add(new WorkflowServiceErrorImpl("ActionList Refresh Rate must be in whole minutes", "preferences.refreshRate"));
        }
        catch (NullPointerException e1) {
            errors.add(new WorkflowServiceErrorImpl("ActionList Refresh Rate must be in whole minutes", "preferences.refreshRate"));
        }
        try {
            if (new Integer(preferences.getPageSize().trim()) == 0) {
                errors.add(new WorkflowServiceErrorImpl("ActionList Page Size must be non-zero ", "preferences.pageSize"));
            }
        }
        catch (NumberFormatException e) {
            errors.add(new WorkflowServiceErrorImpl("ActionList Page Size must be in whole minutes", "preferences.pageSize"));
        }
        catch (NullPointerException e1) {
            errors.add(new WorkflowServiceErrorImpl("ActionList Page Size must be in whole minutes", "preferences.pageSize"));
        }
        LOG.debug("end validating preferences");
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("Preference Validation Error", errors);
        }
    }

    public UserOptionsService getUserOptionService() {
        return (UserOptionsService)KEWServiceLocator.getService("enUserOptionsService");
    }

    static {
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_A", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_X", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_C", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_D", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_R", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_E", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_F", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_I", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_P", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COLOR_S", "userOptions.default.color");
        USER_OPTION_KEY_DEFAULT_MAP.put("EMAIL_NOTIFICATION", "userOptions.default.email");
        USER_OPTION_KEY_DEFAULT_MAP.put("EMAIL_NOTIFY_PRIMARY", "userOptions.default.notifyPrimary");
        USER_OPTION_KEY_DEFAULT_MAP.put("EMAIL_NOTIFY_SECONDARY", "userOptions.default.notifySecondary");
        USER_OPTION_KEY_DEFAULT_MAP.put("OPEN_ITEMS_NEW_WINDOW", "userOptions.default.openNewWindow");
        USER_OPTION_KEY_DEFAULT_MAP.put("ACTION_LIST_SIZE_NEW", "userOptions.default.actionListSize");
        USER_OPTION_KEY_DEFAULT_MAP.put("REFRESH_RATE", "userOptions.default.refreshRate");
        USER_OPTION_KEY_DEFAULT_MAP.put("ACTION_REQUESTED_COL_SHOW_NEW", "userOptions.default.showActionRequired");
        USER_OPTION_KEY_DEFAULT_MAP.put("DATE_CREATED_COL_SHOW_NEW", "userOptions.default.showDateCreated");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOC_TYPE_COL_SHOW_NEW", "userOptions.default.showDocumentType");
        USER_OPTION_KEY_DEFAULT_MAP.put("DOCUMENT_STATUS_COL_SHOW_NEW", "userOptions.default.showDocumentStatus");
        USER_OPTION_KEY_DEFAULT_MAP.put("INITIATOR_COL_SHOW_NEW", "showInitiator");
        USER_OPTION_KEY_DEFAULT_MAP.put("DELEGATOR_COL_SHOW_NEW", "userOptions.default.showDelegator");
        USER_OPTION_KEY_DEFAULT_MAP.put("TITLE_COL_SHOW_NEW", "userOptions.default.showTitle");
        USER_OPTION_KEY_DEFAULT_MAP.put("WORKGROUP_REQUEST_COL_SHOW_NEW", "userOptions.default.showWorkgroupRequest");
        USER_OPTION_KEY_DEFAULT_MAP.put("CLEAR_FYI_COL_SHOW_NEW", "userOptions.default.showClearFYI");
        USER_OPTION_KEY_DEFAULT_MAP.put("DELEGATOR_FILTER", "userOptions.default.delegatorFilterOnActionList");
        USER_OPTION_KEY_DEFAULT_MAP.put("PRIMARY_DELEGATE_FILTER", "userOptions.default.primaryDelegatorFilterOnActionList");
        USER_OPTION_KEY_DEFAULT_MAP.put("LAST_APPROVED_DATE_COL_SHOW_NEW", "userOptions.default.showLastApprovedDate");
        USER_OPTION_KEY_DEFAULT_MAP.put("CURRENT_NODE_COL_SHOW_NEW", "userOptions.default.showCurrentNode");
        USER_OPTION_KEY_DEFAULT_MAP.put("USE_OUT_BOX", "userOptions.default.useOutBox");
        USER_OPTION_KEY_DEFAULT_MAP.put("NOTIFY_ACKNOWLEDGE", "userOptions.default.notifyAcknowledge");
        USER_OPTION_KEY_DEFAULT_MAP.put("NOTIFY_APPROVE", "userOptions.default.notifyApprove");
        USER_OPTION_KEY_DEFAULT_MAP.put("NOTIFY_COMPLETE", "userOptions.default.notifyComplete");
        USER_OPTION_KEY_DEFAULT_MAP.put("NOTIFY_FYI", "userOptions.default.notifyFYI");
    }

    private final class UserOptionsWrapper {
        private final UserOptions userOptions;
        private final boolean isSaveRequired;

        public UserOptionsWrapper(UserOptions userOptions, boolean isSaveRequired) {
            this.userOptions = userOptions;
            this.isSaveRequired = isSaveRequired;
        }

        public UserOptions getUserOptions() {
            return this.userOptions;
        }

        public boolean isSaveRequired() {
            return this.isSaveRequired;
        }
    }
}

