/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerStoredProcedureImpl
extends AbstractSequenceManager {
    private Logger log = LoggerFactory.getLogger(SequenceManagerStoredProcedureImpl.class);
    protected static final String PROCEDURE_NAME = "ojb_nextval_proc";
    protected static final String SEQ_NAME_STRING = "SEQ_NAME";
    protected static final String SEQ_ID_STRING = "MAX_KEY";
    protected static final String SEQ_TABLE_NAME = "OJB_NEXTVAL_SEQ";

    public SequenceManagerStoredProcedureImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    protected String sp_createSequenceQuery(String string, long l) {
        return "insert into OJB_NEXTVAL_SEQ (SEQ_NAME,MAX_KEY) values ('" + string + "'," + l + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        boolean bl = false;
        long l = 0L;
        PersistenceBroker persistenceBroker = this.getBrokerForClass();
        if (!persistenceBroker.isInTransaction()) {
            persistenceBroker.beginTransaction();
            bl = true;
        }
        try {
            String string = this.calculateSequenceName(fieldDescriptor);
            try {
                l = this.buildNextSequence(persistenceBroker, fieldDescriptor.getClassDescriptor(), string);
                if (l == 0L) {
                    throw new SequenceManagerException("No incremented value retrieved");
                }
            }
            catch (Exception exception) {
                this.log.info("Could not grab next key, message was " + exception.getMessage() + " - try to write a new sequence entry to database");
                try {
                    long l2 = SequenceManagerHelper.getMaxForExtent(persistenceBroker, fieldDescriptor);
                    this.createSequence(persistenceBroker, fieldDescriptor, string, l2);
                }
                catch (Exception exception2) {
                    String string2 = SystemUtils.LINE_SEPARATOR;
                    throw new SequenceManagerException(string2 + "Could not grab next id, failed with " + string2 + exception.getMessage() + string2 + "Creation of new sequence failed with " + string2 + exception2.getMessage() + string2, exception2);
                }
                try {
                    l = this.buildNextSequence(persistenceBroker, fieldDescriptor.getClassDescriptor(), string);
                }
                catch (Exception exception3) {
                    throw new SequenceManagerException("Could not grab next id although a sequence seems to exist", exception);
                }
            }
        }
        finally {
            if (persistenceBroker != null && bl) {
                persistenceBroker.commitTransaction();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long buildNextSequence(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor, String string) throws LookupException, SQLException, PlatformException {
        Statement statement = null;
        try {
            Connection connection = persistenceBroker.serviceConnectionManager().getConnection();
            statement = this.getPlatform().prepareNextValProcedureStatement(connection, PROCEDURE_NAME, string);
            statement.executeUpdate();
            long l = statement.getLong(1);
            return l;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void createSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string, long l) throws Exception {
        Statement statement = null;
        try {
            statement = persistenceBroker.serviceStatementManager().getGenericStatement(fieldDescriptor.getClassDescriptor(), false);
            statement.execute(this.sp_createSequenceQuery(string, l));
        }
        catch (Exception exception) {
            this.log.error(exception);
            throw new SequenceManagerException("Could not create new row in OJB_NEXTVAL_SEQ table - TABLENAME=" + string + " field=" + fieldDescriptor.getColumnName(), exception);
        }
        finally {
            block11: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!this.log.isDebugEnabled()) break block11;
                    this.log.debug("Threw SQLException while in createSequence and closing stmt", sQLException);
                }
            }
        }
    }
}

