/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.session;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionHoldingListener
implements HttpSessionListener {
    private static final Map<String, HttpSession> SESSION_HOLDER = new ConcurrentHashMap<String, HttpSession>();

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        SESSION_HOLDER.put(session.getId(), session);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        SESSION_HOLDER.remove(session.getId(), session);
    }

    public static Collection<HttpSession> getSessions() {
        return SESSION_HOLDER.values();
    }
}

