/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltinVariable;
import freemarker.core.DefaultToExpression;
import freemarker.core.Dot;
import freemarker.core.DynamicKeyName;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.Macro;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicCall
extends TemplateElement {
    private Expression macroNameExp;
    private Expression macroArgsExp;

    public DynamicCall(Expression macroNameExp, Expression macroArgsExp) {
        this.macroNameExp = macroNameExp;
        this.macroArgsExp = macroArgsExp;
    }

    void accept(Environment env) throws TemplateException, IOException {
        Macro macro = this.getMacro(env);
        if (macro != null) {
            Map namedArgs = this.getMacroArguments(env);
            env.visit(macro, namedArgs, null, null, null);
        }
    }

    protected Macro getMacro(Environment env) throws TemplateException, IOException {
        Macro macro = null;
        TemplateModel macroNameTm = this.macroNameExp.getAsTemplateModel(env);
        if (!(macroNameTm instanceof SimpleScalar)) {
            throw new TemplateException("Macro name expression did not evaluate to scalar", env);
        }
        String macroName = ((SimpleScalar)macroNameTm).getAsString();
        Expression macroExp = this.buildExpression(macroName);
        TemplateModel tm = macroExp.getAsTemplateModel(env);
        if (tm == Macro.DO_NOTHING_MACRO) {
            return macro;
        }
        if (tm instanceof Macro) {
            macro = (Macro)tm;
            if (macro.isFunction) {
                throw new TemplateException("Routine " + macro.getName() + " is a function. A function can only be called " + "within the evaluation of an expression, like from inside ${...}.", env);
            }
        } else {
            throw new TemplateException("Variable given by macro expression did not evaluate to a macro " + macroName, env);
        }
        return macro;
    }

    protected Map getMacroArguments(Environment env) throws TemplateException, IOException {
        HashMap<String, Expression> namedArgs = new HashMap<String, Expression>();
        TemplateModel macroArgsTm = this.macroArgsExp.getAsTemplateModel(env);
        if (!(macroArgsTm instanceof SimpleScalar)) {
            throw new TemplateException("Macro arguments expression did not evaluate to scalar", env);
        }
        String argsString = ((SimpleScalar)macroArgsTm).getAsString();
        argsString = argsString.trim();
        Pattern argPattern = Pattern.compile("(\\w+)\\s*=\\s*((\\w[\\w\\.\\[\\]'\\!]*)?(\".*\")?('.*')?){1}", 32);
        Matcher matcher = argPattern.matcher(argsString);
        while (matcher.find()) {
            namedArgs.put(matcher.group(1), this.buildExpression(matcher.group(2)));
        }
        return namedArgs;
    }

    protected Expression buildExpression(String expressionString) throws ParseException {
        Expression expression = null;
        if ((expressionString = expressionString.trim()).contains("!")) {
            String[] expressionParts = expressionString.split("\\!");
            Expression defaultExpression = null;
            if (expressionParts.length > 1) {
                defaultExpression = this.buildExpression(expressionParts[1]);
            }
            expression = new DefaultToExpression(this.buildExpression(expressionParts[0]), defaultExpression);
        } else if (expressionString.contains("[")) {
            String[] expressionParts = expressionString.split("\\[");
            if (expressionParts[1].trim().endsWith("]")) {
                expressionParts[1] = expressionParts[1].trim();
                expressionParts[1] = expressionParts[1].substring(0, expressionParts[1].length() - 1);
            }
            expression = new DynamicKeyName(this.buildExpression(expressionParts[0]), this.buildExpression(expressionParts[1]));
        } else if (expressionString.contains(".")) {
            String targetKey;
            if (expressionString.startsWith(".")) {
                expressionString = expressionString.substring(1);
                targetKey = expressionString.substring(0, expressionString.indexOf("."));
                expression = new BuiltinVariable(targetKey);
            } else {
                targetKey = expressionString.substring(0, expressionString.indexOf("."));
                expression = this.buildExpression(targetKey);
            }
            expressionString = this.substringAfterDot(expressionString);
            expression = this.buildNextDot(expression, expressionString);
            expressionString = this.substringAfterDot(expressionString);
            while (expressionString != null) {
                expression = this.buildNextDot(expression, expressionString);
                expressionString = this.substringAfterDot(expressionString);
            }
        } else if (expressionString.startsWith("\"") || expressionString.startsWith("'")) {
            expressionString = expressionString.substring(1, expressionString.length() - 1);
            expression = new StringLiteral(expressionString);
        } else {
            expression = new Identifier(expressionString);
        }
        return expression;
    }

    protected Expression buildNextDot(Expression targetExpression, String expressionString) {
        if (expressionString.startsWith(".")) {
            expressionString = expressionString.substring(expressionString.indexOf(".") + 1, expressionString.length());
        }
        String targetKey = null;
        if (expressionString.contains(".")) {
            targetKey = expressionString.substring(0, expressionString.indexOf("."));
            expressionString = expressionString.substring(expressionString.indexOf(".") + 1, expressionString.length());
        } else {
            targetKey = expressionString;
            expressionString = null;
        }
        return new Dot(targetExpression, targetKey);
    }

    protected String substringAfterDot(String expressionString) {
        if (expressionString.contains(".")) {
            return expressionString.substring(expressionString.indexOf(".") + 1, expressionString.length());
        }
        return null;
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer buf = new StringBuffer("<#");
            buf.append(this.macroNameExp.getCanonicalForm());
            buf.append(this.macroArgsExp.getCanonicalForm());
            buf.append("/>");
            return buf.toString();
        }
        return "dynamic-directive-call " + this.macroNameExp;
    }

    String getNodeTypeSymbol() {
        return "#dyncall-" + this.macroNameExp.getCanonicalForm();
    }

    int getParameterCount() {
        return this.macroArgsExp.getParameterCount();
    }

    Object getParameterValue(int idx) {
        return this.macroArgsExp.getParameterValue(idx);
    }

    ParameterRole getParameterRole(int idx) {
        return this.macroArgsExp.getParameterRole(idx);
    }
}

