/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.util.List;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.NaturalLanguageTree;
import org.kuali.rice.krms.api.repository.TranslateBusinessMethods;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextSelectionCriteria;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="ruleManagementService", targetNamespace="http://rice.kuali.org/krms/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface RuleManagementService
extends TranslateBusinessMethods {
    @WebMethod(operationName="createReferenceObjectBinding")
    @WebResult(name="referenceObjectBinding")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, allEntries=true)
    public ReferenceObjectBinding createReferenceObjectBinding(@WebParam(name="referenceObjectDefinition") ReferenceObjectBinding var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getReferenceObjectBinding")
    @WebResult(name="referenceObjectBinding")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'id=' + #p0")
    public ReferenceObjectBinding getReferenceObjectBinding(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getReferenceObjectBindings")
    @XmlElementWrapper(name="referenceObjectBindings", required=true)
    @XmlElement(name="referenceObjectBinding", required=false)
    @WebResult(name="referenceObjectBindings")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'ids=' + #p0")
    public List<ReferenceObjectBinding> getReferenceObjectBindings(@WebParam(name="ids") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findReferenceObjectBindingsByReferenceDiscriminatorType")
    @XmlElementWrapper(name="referenceObjectBindings", required=true)
    @XmlElement(name="referenceObjectBinding", required=false)
    @WebResult(name="referenceObjectBindings")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'referenceObjectReferenceDiscriminatorType=' + #p0")
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceDiscriminatorType(@WebParam(name="referenceObjectReferenceDiscriminatorType") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findReferenceObjectBindingsByKrmsDiscriminatorType")
    @XmlElementWrapper(name="referenceObjectBindings", required=true)
    @XmlElement(name="referenceObjectBinding", required=false)
    @WebResult(name="referenceObjectBindings")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'referenceObjectKrmsDiscriminatorType=' + #p0")
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsDiscriminatorType(@WebParam(name="referenceObjectKrmsDiscriminatorType") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findReferenceObjectBindingsByReferenceObject")
    @XmlElementWrapper(name="referenceObjectBindings", required=true)
    @XmlElement(name="referenceObjectBinding", required=false)
    @WebResult(name="referenceObjectBindings")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'referenceObjectReferenceDiscriminatorType=' + #p0 + '|' + 'referenceObjectId=' + #p1")
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceObject(@WebParam(name="referenceObjectReferenceDiscriminatorType") String var1, @WebParam(name="referenceObjectId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findReferenceObjectBindingsByKrmsObjectId")
    @XmlElementWrapper(name="referenceObjectBindings", required=true)
    @XmlElement(name="referenceObjectBinding", required=false)
    @WebResult(name="referenceObjectBindings")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, key="'krmsObjectId=' + #p0")
    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsObject(@WebParam(name="krmsObjectId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateReferenceObjectBinding")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, allEntries=true)
    public void updateReferenceObjectBinding(ReferenceObjectBinding var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteReferenceObjectBinding")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ReferenceObjectBindingType"}, allEntries=true)
    public void deleteReferenceObjectBinding(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findReferenceObjectBindingIds")
    @XmlElementWrapper(name="referenceObjectBindingIds", required=true)
    @XmlElement(name="referenceObjectBindingId", required=false)
    @WebResult(name="referenceObjectBindingIds")
    public List<String> findReferenceObjectBindingIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createAgenda")
    @WebResult(name="agenda")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public AgendaDefinition createAgenda(@WebParam(name="AgendaDefinition") AgendaDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findCreateAgenda")
    @WebResult(name="agenda")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public AgendaDefinition findCreateAgenda(@WebParam(name="AgendaDefinition") AgendaDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgenda")
    @WebResult(name="agenda")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaType"}, key="'id=' + #p0")
    public AgendaDefinition getAgenda(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaByNameAndContextId")
    @WebResult(name="agenda")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaType"}, key="'name=' + #p0 + '|' + 'contextId=' + #p1")
    public AgendaDefinition getAgendaByNameAndContextId(@WebParam(name="name") String var1, @WebParam(name="contextId") String var2);

    @WebMethod(operationName="getAgendasByType")
    @XmlElementWrapper(name="agendas", required=true)
    @XmlElement(name="agenda", required=false)
    @WebResult(name="agendas")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaType"}, key="'typeId=' + #p0")
    public List<AgendaDefinition> getAgendasByType(@WebParam(name="typeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendasByContext")
    @XmlElementWrapper(name="agendas", required=true)
    @XmlElement(name="agenda", required=false)
    @WebResult(name="agendas")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaType"}, key="'contextId=' + #p0")
    public List<AgendaDefinition> getAgendasByContext(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendasByTypeAndContext")
    @XmlElementWrapper(name="agendas", required=true)
    @XmlElement(name="agenda", required=false)
    @WebResult(name="agendas")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaType"}, key="'typeId=' + #p0 + '|' + 'contextId=' + #p1")
    public List<AgendaDefinition> getAgendasByTypeAndContext(@WebParam(name="typeId") String var1, @WebParam(name="contextId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateAgenda")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void updateAgenda(@WebParam(name="agendaDefinition") AgendaDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteAgenda")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void deleteAgenda(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createAgendaItem")
    @WebResult(name="agendaItem")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public AgendaItemDefinition createAgendaItem(@WebParam(name="AgendaItemDefinition") AgendaItemDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaItem")
    @WebResult(name="agendaItem")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaItemType"}, key="'id=' + #p0")
    public AgendaItemDefinition getAgendaItem(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaItemsByType")
    @XmlElementWrapper(name="agendaItems", required=true)
    @XmlElement(name="agendaItem", required=false)
    @WebResult(name="agendaItems")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaItemType"}, key="'typeId=' + #p0")
    public List<AgendaItemDefinition> getAgendaItemsByType(@WebParam(name="typeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaItemsByContext")
    @XmlElementWrapper(name="agendaItems", required=true)
    @XmlElement(name="agendaItem", required=false)
    @WebResult(name="agendaItems")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaItemType"}, key="'contextId=' + #p0")
    public List<AgendaItemDefinition> getAgendaItemsByContext(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaItemsByTypeAndContext")
    @XmlElementWrapper(name="agendaItems", required=true)
    @XmlElement(name="agendaItem", required=false)
    @WebResult(name="agendaItems")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaItemType"}, key="'typeId=' + #p0 + '|' + 'contextId=' + #p1")
    public List<AgendaItemDefinition> getAgendaItemsByTypeAndContext(@WebParam(name="typeId") String var1, @WebParam(name="contextId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateAgendaItem")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void updateAgendaItem(@WebParam(name="agendaItemDefinition") AgendaItemDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteAgendaItem")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition", "http://rice.kuali.org/krms/v2_0/AgendaType", "http://rice.kuali.org/krms/v2_0/AgendaItemType", "http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void deleteAgendaItem(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createRule")
    @WebResult(name="rule")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/RuleType", "http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/AgendaItemType"}, allEntries=true)
    public RuleDefinition createRule(@WebParam(name="ruleDefinition") RuleDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRule")
    @WebResult(name="rule")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/RuleType"}, key="'ruleId=' + #p0")
    public RuleDefinition getRule(@WebParam(name="ruleId") String var1);

    @WebMethod(operationName="getRuleByNameAndNamespace")
    @WebResult(name="rule")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/RuleType"}, key="'name=' + #p0 + '|' + 'namespace=' + #p1")
    public RuleDefinition getRuleByNameAndNamespace(@WebParam(name="name") String var1, @WebParam(name="namespace") String var2);

    @WebMethod(operationName="getRules")
    @XmlElementWrapper(name="rules", required=true)
    @XmlElement(name="rule", required=false)
    @WebResult(name="rules")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/RuleType"}, key="'ruleIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<RuleDefinition> getRules(@WebParam(name="ruleIds") List<String> var1);

    @WebMethod(operationName="updateRule")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/RuleType", "http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/AgendaItemType"}, allEntries=true)
    public void updateRule(@WebParam(name="ruleDefinition") RuleDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteRule")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/RuleType", "http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/AgendaItemType"}, allEntries=true)
    public void deleteRule(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createAction")
    @WebResult(name="action")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public ActionDefinition createAction(@WebParam(name="actionDefinition") ActionDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAction")
    @WebResult(name="action")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ActionType"}, key="'actionId=' + #p0")
    public ActionDefinition getAction(@WebParam(name="actionId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActions")
    @XmlElementWrapper(name="actions", required=true)
    @XmlElement(name="action", required=false)
    @WebResult(name="actions")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ActionType"}, key="'actionIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<ActionDefinition> getActions(@WebParam(name="actionIds") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateAction")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public void updateAction(@WebParam(name="actionDefinition") ActionDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteAction")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ActionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public void deleteAction(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createProposition")
    @WebResult(name="proposition")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public PropositionDefinition createProposition(@WebParam(name="propositionDefinition") PropositionDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getProposition")
    @WebResult(name="proposition")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/PropositionType"}, key="'id=' + #p0")
    public PropositionDefinition getProposition(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPropositionsByType")
    @XmlElementWrapper(name="propositions", required=true)
    @XmlElement(name="proposition", required=false)
    @WebResult(name="propositions")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/PropositionType"}, key="'typeId=' + #p0")
    public Set<PropositionDefinition> getPropositionsByType(@WebParam(name="typeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPropositionsByRule")
    @XmlElementWrapper(name="propositions", required=true)
    @XmlElement(name="proposition", required=false)
    @WebResult(name="propositions")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/PropositionType"}, key="'ruleId=' + #p0")
    public Set<PropositionDefinition> getPropositionsByRule(@WebParam(name="ruleId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateProposition")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public void updateProposition(@WebParam(name="propositionDefinition") PropositionDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteProposition")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/PropositionType", "http://rice.kuali.org/krms/v2_0/RuleType"}, allEntries=true)
    public void deleteProposition(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createNaturalLanguageUsage")
    @WebResult(name="naturalLanguageUsage")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType", "http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public NaturalLanguageUsage createNaturalLanguageUsage(@WebParam(name="naturalLanguageUsage") NaturalLanguageUsage var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNaturalLanguageUsage")
    @WebResult(name="naturalLanguageUsage")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType"}, key="'id=' + #p0")
    public NaturalLanguageUsage getNaturalLanguageUsage(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNaturalLanguageUsageByNameAndNamespace")
    @WebResult(name="naturalLanguageUsage")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType"}, key="'name=' + #p0 + '|' + 'namespace=' + #p1")
    public NaturalLanguageUsage getNaturalLanguageUsageByNameAndNamespace(@WebParam(name="name") String var1, @WebParam(name="namespace") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateNaturalLanguageUsage")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType", "http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public void updateNaturalLanguageUsage(@WebParam(name="naturalLanguageUsage") NaturalLanguageUsage var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteNaturalLanguageUsage")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType", "http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public void deleteNaturalLanguageUsage(@WebParam(name="naturalLanguageUsageId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNaturalLanguageUsagesByNamespace")
    @XmlElementWrapper(name="naturalLanguageUsages", required=true)
    @XmlElement(name="naturalLanguageUsage", required=false)
    @WebResult(name="naturalLanguageUsages")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageUsageType"}, key="'namespace=' + #p0")
    public List<NaturalLanguageUsage> getNaturalLanguageUsagesByNamespace(@WebParam(name="namespace") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createContext")
    @WebResult(name="context")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public ContextDefinition createContext(@WebParam(name="contextDefinition") ContextDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findCreateContext")
    @WebResult(name="context")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public ContextDefinition findCreateContext(@WebParam(name="contextDefinition") ContextDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateContext")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void updateContext(@WebParam(name="contextDefinition") ContextDefinition var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteContext")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, allEntries=true)
    public void deleteContext(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getContext")
    @WebResult(name="context")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, key="'id=' + #p0")
    public ContextDefinition getContext(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getContextByNameAndNamespace")
    @WebResult(name="context")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/ContextDefinitionType"}, key="'name=' + #p0 + '|' + 'namespace=' + #p1")
    public ContextDefinition getContextByNameAndNamespace(@WebParam(name="name") String var1, @WebParam(name="namespace") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createNaturalLanguageTemplate")
    @WebResult(name="naturalLanguageTemplate")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public NaturalLanguageTemplate createNaturalLanguageTemplate(@WebParam(name="naturalLanguageTemplate") NaturalLanguageTemplate var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNaturalLanguageTemplate")
    @WebResult(name="naturalLanguageTemplate")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'naturalLanguageTemplateId=' + #p0")
    public NaturalLanguageTemplate getNaturalLanguageTemplate(@WebParam(name="naturalLanguageTemplateId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateNaturalLanguageTemplate")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public void updateNaturalLanguageTemplate(@WebParam(name="naturalLanguageTemplate") NaturalLanguageTemplate var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteNaturalLanguageTemplate")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, allEntries=true)
    public void deleteNaturalLanguageTemplate(@WebParam(name="naturalLanguageTemplateId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findNaturalLanguageTemplatesByLanguageCode")
    @XmlElementWrapper(name="naturalLangaugeTemplates", required=true)
    @XmlElement(name="naturalLangaugeTemplate", required=false)
    @WebResult(name="naturalLangaugeTemplates")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'languageCode=' + #p0")
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByLanguageCode(@WebParam(name="languageCode") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId")
    @WebResult(name="naturalLangaugeTemplate")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'languageCode=' + #p0 + '|' + 'typeId=' + #p1 + '|' + 'naturalLanguageUsageId=' + #p2")
    public NaturalLanguageTemplate findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(@WebParam(name="languageCode") String var1, @WebParam(name="typeId") String var2, @WebParam(name="naturalLanguageUsageId") String var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findNaturalLanguageTemplatesByNaturalLanguageUsage")
    @XmlElementWrapper(name="naturalLangaugeTemplates", required=true)
    @XmlElement(name="naturalLangaugeTemplate", required=false)
    @WebResult(name="naturalLangaugeTemplates")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'naturalLanguageUsageId=' + #p0")
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByNaturalLanguageUsage(@WebParam(name="naturalLanguageUsageId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findNaturalLanguageTemplatesByType")
    @XmlElementWrapper(name="naturalLangaugeTemplates", required=true)
    @XmlElement(name="naturalLangaugeTemplate", required=false)
    @WebResult(name="naturalLangaugeTemplates")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'typeId=' + #p0")
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByType(@WebParam(name="typeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findNaturalLanguageTemplatesByTemplate")
    @XmlElementWrapper(name="naturalLangaugeTemplates", required=true)
    @XmlElement(name="naturalLangaugeTemplate", required=false)
    @WebResult(name="naturalLangaugeTemplates")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/NaturalLanguageTemplateType"}, key="'template=' + #p0")
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByTemplate(@WebParam(name="template") String var1) throws RiceIllegalArgumentException;

    @Override
    @WebMethod(operationName="translateNaturalLanguageForObject")
    @WebResult(name="naturalLanguage")
    public String translateNaturalLanguageForObject(@WebParam(name="naturalLanguageUsageId") String var1, @WebParam(name="typeId") String var2, @WebParam(name="krmsObjectId") String var3, @WebParam(name="languageCode") String var4) throws RiceIllegalArgumentException;

    @Override
    @WebMethod(operationName="translateNaturalLanguageForProposition")
    @WebResult(name="naturalLanguage")
    public String translateNaturalLanguageForProposition(@WebParam(name="naturalLanguageUsageId") String var1, @WebParam(name="propositionDefinintion") PropositionDefinition var2, @WebParam(name="languageCode") String var3) throws RiceIllegalArgumentException;

    @Override
    @WebMethod(operationName="translateNaturalLanguageTreeForProposition")
    @WebResult(name="naturalLanguageTree")
    public NaturalLanguageTree translateNaturalLanguageTreeForProposition(@WebParam(name="naturalLanguageUsageId") String var1, @WebParam(name="propositionDefinintion") PropositionDefinition var2, @WebParam(name="languageCode") String var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findContextIds")
    @XmlElementWrapper(name="contextIds", required=true)
    @XmlElement(name="context", required=false)
    @WebResult(name="contextIds")
    public List<String> findContextIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAgendaIds")
    @XmlElementWrapper(name="contextIds", required=true)
    @XmlElement(name="agenda", required=false)
    @WebResult(name="agendaIds")
    public List<String> findAgendaIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findRuleIds")
    @XmlElementWrapper(name="ruleIds", required=true)
    @XmlElement(name="rule", required=false)
    @WebResult(name="ruleIds")
    public List<String> findRuleIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findPropositionIds")
    @XmlElementWrapper(name="propositionIds", required=true)
    @XmlElement(name="proposition", required=false)
    @WebResult(name="propositionIds")
    public List<String> findPropositionIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findActionIds")
    @XmlElementWrapper(name="actionIds", required=true)
    @XmlElement(name="action", required=false)
    @WebResult(name="actionIds")
    public List<String> findActionIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="selectContext")
    @WebResult(name="contextDefinition")
    public ContextDefinition selectContext(@WebParam(name="contextSelectionCriteria") ContextSelectionCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaTree")
    @WebResult(name="agendaTree")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition"}, key="'agendaId=' + #p0")
    public AgendaTreeDefinition getAgendaTree(@WebParam(name="agendaId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaTrees")
    @XmlElementWrapper(name="agendaTrees", required=true)
    @XmlElement(name="agendaTree", required=false)
    @WebResult(name="agendaTrees")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition"}, key="'agendaIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<AgendaTreeDefinition> getAgendaTrees(@WebParam(name="agendaIds") List<String> var1) throws RiceIllegalArgumentException;
}

