/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.person;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;

public class PersonRolodexComparator
implements Comparator<PersonRolodex> {
    private static final Logger LOG = LogManager.getLogger(PersonRolodexComparator.class);
    public static final Comparator<PersonRolodex> INSTANCE = new PersonRolodexComparator();

    @Override
    public int compare(PersonRolodex person1, PersonRolodex person2) {
        int retval = 0;
        if (person1.isInvestigator() || person2.isInvestigator()) {
            if (person1.isPrincipalInvestigator() || person2.isPrincipalInvestigator()) {
                if (person1.isPrincipalInvestigator()) {
                    --retval;
                }
                if (person2.isPrincipalInvestigator()) {
                    ++retval;
                }
            }
            if (retval == 0 && (person1.isMultiplePi() || person2.isMultiplePi())) {
                if (person1.isMultiplePi()) {
                    --retval;
                }
                if (person2.isMultiplePi()) {
                    ++retval;
                }
            }
        }
        if (retval == 0) {
            retval = this.massageOrdinalNumber(person1).compareTo(this.massageOrdinalNumber(person2));
        }
        if (retval == 0) {
            if (StringUtils.isNotBlank((CharSequence)person1.getFullName()) && StringUtils.isNotBlank((CharSequence)person1.getLastName()) && StringUtils.isNotBlank((CharSequence)person2.getLastName())) {
                retval = person1.getLastName().compareTo(person2.getLastName());
            } else if (StringUtils.isNotBlank((CharSequence)person2.getLastName())) {
                --retval;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("retval = " + retval);
        }
        return retval;
    }

    private Integer massageOrdinalNumber(PersonRolodex person) {
        return person.getOrdinalPosition() != null ? person.getOrdinalPosition() : -1;
    }
}

