/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.support.ServiceBusExporter;

public class PropertyConditionalServiceBusExporter
extends ServiceBusExporter {
    private List<String> exportIf = new ArrayList<String>();
    private List<String> exportUnless = new ArrayList<String>();
    private boolean exportIfPropertyNotSet = true;

    @Override
    public void afterPropertiesSet() {
        if (this.shouldRemoteThisService()) {
            super.afterPropertiesSet();
        }
    }

    protected boolean shouldRemoteThisService() {
        if (this.exportIf.isEmpty() && this.exportUnless.isEmpty()) {
            return true;
        }
        boolean remoteThisService = false;
        String serviceValue = null;
        for (String expIf : this.exportIf) {
            serviceValue = ConfigContext.getCurrentContextConfig().getProperty(expIf);
            if (!StringUtils.isBlank((String)serviceValue)) {
                remoteThisService = Boolean.parseBoolean(serviceValue);
                if (!remoteThisService) continue;
                break;
            }
            if (!this.exportIfPropertyNotSet) continue;
            remoteThisService = true;
            break;
        }
        for (String expUnless : this.exportUnless) {
            serviceValue = ConfigContext.getCurrentContextConfig().getProperty(expUnless);
            if (StringUtils.isBlank((String)serviceValue) || !(remoteThisService = Boolean.parseBoolean(serviceValue))) continue;
            remoteThisService = false;
            break;
        }
        return remoteThisService;
    }

    public List<String> getExportIf() {
        return this.exportIf;
    }

    public void setExportIf(List<String> exportIf) {
        this.exportIf = exportIf;
    }

    public List<String> getExportUnless() {
        return this.exportUnless;
    }

    public void setExportUnless(List<String> exportUnless) {
        this.exportUnless = exportUnless;
    }

    public boolean isExportIfPropertyNotSet() {
        return this.exportIfPropertyNotSet;
    }

    public void setExportIfPropertyNotSet(boolean exportIfPropertyNotSet) {
        this.exportIfPropertyNotSet = exportIfPropertyNotSet;
    }
}

