/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.service.ViewHelperService;

@BeanTag(name="attributeQuery", parent="Uif-AttributeQueryConfig")
public class AttributeQuery
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = -4569905665441735255L;
    private String dataObjectClassName;
    private boolean renderNotFoundMessage = true;
    private String returnMessageText;
    private String returnMessageStyleClasses;
    private Map<String, String> queryFieldMapping = new HashMap<String, String>();
    private Map<String, String> returnFieldMapping = new HashMap<String, String>();
    private Map<String, String> additionalCriteria = new HashMap<String, String>();
    private List<String> sortPropertyNames = new ArrayList<String>();
    private String queryMethodToCall;
    private List<String> queryMethodArgumentFieldList = new ArrayList<String>();
    private MethodInvokerConfig queryMethodInvokerConfig = new MethodInvokerConfig();

    public void defaultQueryTarget(ViewHelperService viewHelperService) {
        if (this.queryMethodInvokerConfig != null && this.queryMethodInvokerConfig.getTargetClass() == null && this.queryMethodInvokerConfig.getTargetObject() == null) {
            this.queryMethodInvokerConfig.setTargetClass(viewHelperService.getClass());
        }
    }

    public void updateQueryFieldMapping(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedQueryFieldMapping = new HashMap<String, String>();
        for (String fromFieldPath : this.getQueryFieldMapping().keySet()) {
            String toField = this.getQueryFieldMapping().get(fromFieldPath);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromFieldPath);
            adjustedQueryFieldMapping.put(adjustedFromFieldPath, toField);
        }
        this.queryFieldMapping = adjustedQueryFieldMapping;
    }

    public void updateReturnFieldMapping(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedReturnFieldMapping = new HashMap<String, String>();
        for (String fromFieldPath : this.getReturnFieldMapping().keySet()) {
            String toFieldPath = this.getReturnFieldMapping().get(fromFieldPath);
            String adjustedToFieldPath = bindingInfo.getPropertyAdjustedBindingPath(toFieldPath);
            adjustedReturnFieldMapping.put(fromFieldPath, adjustedToFieldPath);
        }
        this.returnFieldMapping = adjustedReturnFieldMapping;
    }

    public void updateQueryMethodArgumentFieldList(BindingInfo bindingInfo) {
        ArrayList<String> adjustedArgumentFieldList = new ArrayList<String>();
        for (String argumentFieldPath : this.getQueryMethodArgumentFieldList()) {
            String adjustedFieldPath = bindingInfo.getPropertyAdjustedBindingPath(argumentFieldPath);
            adjustedArgumentFieldList.add(adjustedFieldPath);
        }
        this.queryMethodArgumentFieldList = adjustedArgumentFieldList;
    }

    public String getQueryFieldMappingJsString() {
        Object queryFieldMappingJs = "{";
        for (String queryField : this.queryFieldMapping.keySet()) {
            if (!StringUtils.equals((String)queryFieldMappingJs, (String)"{")) {
                queryFieldMappingJs = (String)queryFieldMappingJs + ",";
            }
            queryFieldMappingJs = (String)queryFieldMappingJs + "\"" + queryField + "\":\"" + this.queryFieldMapping.get(queryField) + "\"";
        }
        queryFieldMappingJs = (String)queryFieldMappingJs + "}";
        return queryFieldMappingJs;
    }

    public String getReturnFieldMappingJsString() {
        Object returnFieldMappingJs = "{";
        for (String fromField : this.returnFieldMapping.keySet()) {
            if (!StringUtils.equals((String)returnFieldMappingJs, (String)"{")) {
                returnFieldMappingJs = (String)returnFieldMappingJs + ",";
            }
            returnFieldMappingJs = (String)returnFieldMappingJs + "\"" + this.returnFieldMapping.get(fromField) + "\":\"" + fromField + "\"";
        }
        returnFieldMappingJs = (String)returnFieldMappingJs + "}";
        return returnFieldMappingJs;
    }

    public String getQueryMethodArgumentFieldsJsString() {
        Object queryMethodArgsJs = "{";
        for (String methodArg : this.queryMethodArgumentFieldList) {
            if (!StringUtils.equals((String)queryMethodArgsJs, (String)"{")) {
                queryMethodArgsJs = (String)queryMethodArgsJs + ",";
            }
            queryMethodArgsJs = (String)queryMethodArgsJs + "\"" + methodArg + "\":\"" + methodArg + "\"";
        }
        queryMethodArgsJs = (String)queryMethodArgsJs + "}";
        return queryMethodArgsJs;
    }

    public boolean hasConfiguredMethod() {
        boolean configuredMethod = false;
        if (StringUtils.isNotBlank((String)this.getQueryMethodToCall())) {
            configuredMethod = true;
        } else if (this.getQueryMethodInvokerConfig() != null && (StringUtils.isNotBlank((String)this.getQueryMethodInvokerConfig().getTargetMethod()) || StringUtils.isNotBlank((String)this.getQueryMethodInvokerConfig().getStaticMethod()))) {
            configuredMethod = true;
        }
        return configuredMethod;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public Map<String, String> getQueryFieldMapping() {
        return this.queryFieldMapping;
    }

    public void setQueryFieldMapping(Map<String, String> queryFieldMapping) {
        this.queryFieldMapping = queryFieldMapping;
    }

    @BeanTagAttribute
    public Map<String, String> getReturnFieldMapping() {
        return this.returnFieldMapping;
    }

    public void setReturnFieldMapping(Map<String, String> returnFieldMapping) {
        this.returnFieldMapping = returnFieldMapping;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalCriteria() {
        return this.additionalCriteria;
    }

    public void setAdditionalCriteria(Map<String, String> additionalCriteria) {
        this.additionalCriteria = additionalCriteria;
    }

    @BeanTagAttribute
    public List<String> getSortPropertyNames() {
        return this.sortPropertyNames;
    }

    public void setSortPropertyNames(List<String> sortPropertyNames) {
        this.sortPropertyNames = sortPropertyNames;
    }

    @BeanTagAttribute
    public boolean isRenderNotFoundMessage() {
        return this.renderNotFoundMessage;
    }

    public void setRenderNotFoundMessage(boolean renderNotFoundMessage) {
        this.renderNotFoundMessage = renderNotFoundMessage;
    }

    @BeanTagAttribute
    public String getReturnMessageText() {
        return this.returnMessageText;
    }

    public void setReturnMessageText(String returnMessageText) {
        this.returnMessageText = returnMessageText;
    }

    @BeanTagAttribute
    public String getReturnMessageStyleClasses() {
        return this.returnMessageStyleClasses;
    }

    public void setReturnMessageStyleClasses(String returnMessageStyleClasses) {
        this.returnMessageStyleClasses = returnMessageStyleClasses;
    }

    @BeanTagAttribute
    public String getQueryMethodToCall() {
        return this.queryMethodToCall;
    }

    public void setQueryMethodToCall(String queryMethodToCall) {
        this.queryMethodToCall = queryMethodToCall;
    }

    @BeanTagAttribute
    public List<String> getQueryMethodArgumentFieldList() {
        return this.queryMethodArgumentFieldList;
    }

    public void setQueryMethodArgumentFieldList(List<String> queryMethodArgumentFieldList) {
        this.queryMethodArgumentFieldList = queryMethodArgumentFieldList;
    }

    @BeanTagAttribute
    public MethodInvokerConfig getQueryMethodInvokerConfig() {
        return this.queryMethodInvokerConfig;
    }

    public void setQueryMethodInvokerConfig(MethodInvokerConfig queryMethodInvokerConfig) {
        this.queryMethodInvokerConfig = queryMethodInvokerConfig;
    }

    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("AttributeQuery", "NOBEANID");
        if (this.getDataObjectClassName() == null && this.getQueryMethodToCall() == null && this.getQueryMethodInvokerConfig() == null) {
            String[] currentValues = new String[]{"dataObjectClassName = " + this.getDataObjectClassName(), "queryMethodToCall = " + this.getQueryMethodToCall(), "queryMethodInvokerConfig = " + this.getQueryMethodInvokerConfig()};
            tracer.createWarning("At least 1 should be set: dataObjectClass, queryMethodToCall or queryMethodInvokerConfig", currentValues);
        }
    }
}

