/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TransactionHandlerInterceptor
implements HandlerInterceptor {
    private static final ThreadLocal<TransactionStatus> context = new ThreadLocal();
    @Autowired
    @Qualifier(value="transactionManager")
    PlatformTransactionManager txManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("request");
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        context.set(status);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.completeTransaction(null);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.completeTransaction(ex);
    }

    protected void completeTransaction(Exception ex) {
        TransactionStatus status = context.get();
        if (status == null) {
            return;
        }
        try {
            if (!status.isCompleted()) {
                if (ex == null && !status.isRollbackOnly()) {
                    this.txManager.commit(status);
                } else {
                    this.txManager.rollback(status);
                }
            }
        }
        finally {
            context.remove();
        }
    }
}

