/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.util.UrlFactory;

@BeanTag(name="groupLinkField", parent="Uif-GroupLinkField")
public class GroupLinkField
extends LinkField {
    private static final long serialVersionUID = 6304287260087690284L;
    private static final Logger LOG = LogManager.getLogger(GroupLinkField.class);
    private String groupId;
    private String groupName;
    private String groupNamespaceCode;
    private String dataObjectClassName;
    private String baseInquiryUrl;
    private boolean namespaceInLinkText;
    private boolean disableLink;
    private Map<String, String> additionalInquiryParameters;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isNotBlank((String)this.groupId)) {
            this.setHref(this.buildInquiryUrl());
            this.setLinkText(this.getGroupNameByGroupId(this.groupId));
        } else {
            if (StringUtils.isNotBlank((String)this.groupName) && StringUtils.isNotBlank((String)this.groupNamespaceCode)) {
                this.setHref(this.buildInquiryUrl());
                this.setLinkText(this.getGroupNameByNamespaceAndName(this.groupNamespaceCode, this.groupName));
            }
            if (StringUtils.isBlank((String)this.groupName) && StringUtils.isNotBlank((String)this.groupNamespaceCode)) {
                this.setDisableLink(true);
                if (this.isNamespaceInLinkText()) {
                    this.setLinkText(this.groupNamespaceCode);
                }
            }
            if (StringUtils.isNotBlank((String)this.groupName) && StringUtils.isBlank((String)this.groupNamespaceCode)) {
                this.setDisableLink(true);
                this.setLinkText(this.groupName);
            }
        }
        if (StringUtils.isBlank((String)this.getHref())) {
            this.setDisableLink(true);
        }
        if (StringUtils.isBlank((String)this.getLinkText())) {
            this.setLinkText("&nbsp;");
        }
    }

    protected String buildInquiryUrl() {
        Class<?> inquiryObjectClass;
        try {
            inquiryObjectClass = Class.forName(this.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to get class for: " + this.getDataObjectClassName());
            throw new RuntimeException(e);
        }
        Properties urlParameters = new Properties();
        urlParameters.setProperty("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.setProperty("methodToCall", "start");
        if (StringUtils.isNotBlank((String)this.groupId)) {
            urlParameters.setProperty("id", this.groupId);
        } else if (StringUtils.isNotBlank((String)this.groupName)) {
            urlParameters.setProperty("name", this.groupName);
            urlParameters.setProperty("namespaceCode", this.groupNamespaceCode);
        }
        for (Map.Entry<String, String> inquiryParameter : this.additionalInquiryParameters.entrySet()) {
            urlParameters.setProperty(inquiryParameter.getKey(), inquiryParameter.getValue());
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
        String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
        return inquiryUrl;
    }

    protected String getGroupNameByGroupId(String groupId) {
        Group group = KimApiServiceLocator.getGroupService().getGroup(groupId);
        if (group == null) {
            this.setDisableLink(true);
            return groupId;
        }
        if (this.isNamespaceInLinkText()) {
            return group.getNamespaceCode() + " " + group.getName();
        }
        return group.getName();
    }

    protected String getGroupNameByNamespaceAndName(String namespaceCode, String groupName) {
        Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
        if (group == null) {
            this.setDisableLink(true);
            if (this.isNamespaceInLinkText()) {
                return this.groupNamespaceCode + " " + this.groupName;
            }
            return this.groupName;
        }
        if (this.isNamespaceInLinkText()) {
            return group.getNamespaceCode() + " " + group.getName();
        }
        return group.getName();
    }

    @BeanTagAttribute
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @BeanTagAttribute
    public String getGroupNamespaceCode() {
        return this.groupNamespaceCode;
    }

    public void setGroupNamespaceCode(String groupNamespaceCode) {
        this.groupNamespaceCode = groupNamespaceCode;
    }

    @BeanTagAttribute
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    @BeanTagAttribute
    public boolean isNamespaceInLinkText() {
        return this.namespaceInLinkText;
    }

    public void setNamespaceInLinkText(boolean namespaceInLinkText) {
        this.namespaceInLinkText = namespaceInLinkText;
    }

    @BeanTagAttribute
    public boolean isDisableLink() {
        return this.disableLink;
    }

    public void setDisableLink(boolean disableLink) {
        this.disableLink = disableLink;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalInquiryParameters() {
        return this.additionalInquiryParameters;
    }

    public void setAdditionalInquiryParameters(Map<String, String> additionalInquiryParameters) {
        this.additionalInquiryParameters = additionalInquiryParameters;
    }
}

