/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.krad.kim.NamespacePermissionTypeServiceImpl;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl
extends NamespacePermissionTypeServiceImpl {
    protected static final String NAMESPACE_CODE = "namespaceCode";
    protected String exactMatchStringAttributeName;
    protected boolean namespaceRequiredOnStoredMap;
    private List<String> requiredAttributes = new ArrayList<String>();
    private CriteriaLookupService criteriaLookupService;

    protected List<String> getRequiredAttributes() {
        return Collections.unmodifiableList(this.requiredAttributes);
    }

    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        List<Permission> matchingWithNamespace;
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        ArrayList<Permission> matchingBlankPermissions = new ArrayList<Permission>();
        String requestedAttributeValue = requestedDetails.get(this.exactMatchStringAttributeName);
        for (Permission kpi : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)kpi);
            String permissionAttributeValue = (String)bo.getDetails().get(this.exactMatchStringAttributeName);
            if (StringUtils.equals((String)requestedAttributeValue, (String)permissionAttributeValue)) {
                matchingPermissions.add(kpi);
                continue;
            }
            if (!StringUtils.isBlank((String)permissionAttributeValue)) continue;
            matchingBlankPermissions.add(kpi);
        }
        if (!matchingPermissions.isEmpty()) {
            matchingWithNamespace = super.performPermissionMatches(requestedDetails, matchingPermissions);
            if (!this.namespaceRequiredOnStoredMap && matchingWithNamespace.isEmpty()) {
                return matchingPermissions;
            }
            return matchingWithNamespace;
        }
        if (!matchingBlankPermissions.isEmpty()) {
            matchingWithNamespace = super.performPermissionMatches(requestedDetails, matchingBlankPermissions);
            if (!this.namespaceRequiredOnStoredMap && matchingWithNamespace.isEmpty()) {
                return matchingBlankPermissions;
            }
            return matchingWithNamespace;
        }
        return matchingPermissions;
    }

    public void setExactMatchStringAttributeName(String exactMatchStringAttributeName) {
        this.exactMatchStringAttributeName = exactMatchStringAttributeName;
        this.requiredAttributes.add(exactMatchStringAttributeName);
    }

    public void setNamespaceRequiredOnStoredMap(boolean namespaceRequiredOnStoredMap) {
        this.namespaceRequiredOnStoredMap = namespaceRequiredOnStoredMap;
    }

    protected List<RemotableAttributeError> validateReferencesExistAndActive(KimType kimType, Map<String, String> attributes, List<RemotableAttributeError> previousValidationErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        HashMap<String, String> nonNamespaceCodeAttributes = new HashMap<String, String>(attributes);
        if (attributes.containsKey(NAMESPACE_CODE)) {
            nonNamespaceCodeAttributes.remove(NAMESPACE_CODE);
            String namespaceCode = attributes.get(NAMESPACE_CODE);
            QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.like((String)"code", (CharSequence)namespaceCode)});
            List namespaces = this.getCriteriaLookupService().lookup(NamespaceBo.class, criteria).getResults();
            if (!namespaces.isEmpty()) {
                for (NamespaceBo namespace : namespaces) {
                    errors.addAll(super.validateReferencesExistAndActive(kimType, Collections.singletonMap(NAMESPACE_CODE, namespace.getCode()), previousValidationErrors));
                }
            } else {
                errors.addAll(super.validateReferencesExistAndActive(kimType, Collections.singletonMap(NAMESPACE_CODE, namespaceCode), previousValidationErrors));
            }
        }
        errors.addAll(super.validateReferencesExistAndActive(kimType, nonNamespaceCodeAttributes, previousValidationErrors));
        return errors;
    }

    public CriteriaLookupService getCriteriaLookupService() {
        if (this.criteriaLookupService == null) {
            this.criteriaLookupService = (CriteriaLookupService)KRADServiceLocatorWeb.getService((String)"criteriaLookupService");
        }
        return this.criteriaLookupService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

