/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectReview;
import org.kuali.kra.excon.service.ExconProjectService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krms.api.engine.Facts;

public class ExconProjectDocument
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final long serialVersionUID = 5454824570787613256L;
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private static final Logger LOG = LogManager.getLogger(ExconProjectDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "ECPJ";
    private List<ExconProject> exconProjectList;
    private transient boolean documentSaveAfterVersioning;
    private transient PermissionService permissionService;
    private transient VersionHistoryService versionHistoryService;
    private transient ExconProjectService exconProjectService;
    private transient KcWorkflowService kcWorkflowService;
    private transient DocHandlerService docHandlerService;

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public ExconProjectDocument() {
        this.init();
    }

    public ExconProject getExconProject() {
        return this.getExconProjectList().size() > 0 ? this.getExconProjectList().get(0) : new ExconProject();
    }

    public void setExconProject(ExconProject exconProject) {
        this.exconProjectList.set(0, exconProject);
    }

    public void setExconProjectList(List<ExconProject> exconProjectList) {
        this.exconProjectList = exconProjectList;
    }

    public List<ExconProject> getExconProjectList() {
        return this.exconProjectList;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newStatus = statusChangeEvent.getNewRouteStatus();
        if ("F".equalsIgnoreCase(newStatus)) {
            this.getExconProjectService().updateExconProjectSequenceStatus(this.getExconProject(), VersionStatus.ACTIVE);
            this.getVersionHistoryService().updateVersionHistory(this.getExconProject(), VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
        }
        if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
            this.getExconProjectService().updateExconProjectSequenceStatus(this.getExconProject(), VersionStatus.CANCELED);
            this.getVersionHistoryService().updateVersionHistory(this.getExconProject(), VersionStatus.CANCELED, GlobalVariables.getUserSession().getPrincipalName());
        }
        for (ExconProject exconProject : this.exconProjectList) {
            exconProject.setExconProjectDocument(this);
        }
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved() || workflowDoc.isCompletionRequested();
    }

    public boolean isCanceled() {
        WorkflowDocument workflow = this.getDocumentHeader().getWorkflowDocument();
        return workflow.isCanceled();
    }

    public boolean getCanModify() {
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("projectTypeCode", this.getExconProject().getProjectTypeCode());
        return this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-EXCON", "Modify Project Document", qualifications);
    }

    protected void init() {
        this.exconProjectList = new ArrayList<ExconProject>();
        this.exconProjectList.add(new ExconProject());
    }

    public boolean isDocumentSaveAfterVersioning() {
        return this.documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterVersioning(boolean documentSaveAfterVersioning) {
        this.documentSaveAfterVersioning = documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterExconProjectLookupEditOrVersion(boolean documentSaveAfterVersioning) {
        this.setDocumentSaveAfterVersioning(documentSaveAfterVersioning);
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || this.getKcWorkflowService().hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument()))) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getExconProject().getExconProjectCustomDataList();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ExconProject exconProject = this.getExconProject();
        managedLists.add(exconProject.getExconProjectPersons());
        managedLists.add(exconProject.getExconProjectUnitPersons());
        managedLists.add(exconProject.getExconProjectRPSEntities());
        managedLists.add(exconProject.getExconProjectRPSResults());
        managedLists.add(exconProject.getExconProjectEvents());
        managedLists.add(exconProject.getExconProjectDestinations());
        managedLists.add(exconProject.getExconProjectComments());
        managedLists.add(exconProject.getExconProjectAttachments());
        managedLists.add(exconProject.getExconProjectExternalInstitutions());
        managedLists.add(exconProject.getExconProjectReviews());
        managedLists.add(exconProject.getExconProjectAssociatedDocuments());
        return managedLists;
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getExconProject().getDocumentKey();
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-EXCON");
        qualifiers.put("name", "KC Export Control Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        this.getKcKrmsFactBuilderServiceHelper().addFacts(factsBuilder, this);
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    public String getLeadUnitNumber() {
        return this.getExconProject().getLeadUnitNumber();
    }

    public String buildForwardUrl() {
        Object forward = this.getDocHandlerService().getDocHandlerUrl(this.getDocumentNumber());
        forward = !((String)(forward = ((String)forward).replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB))).contains("?") ? (String)forward + "?" : (String)forward + "&";
        forward = (String)forward + "docId=" + this.documentNumber;
        forward = (String)forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = (String)forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return "<a href=\"" + (String)forward + "\"target=\"_blank\">" + this.documentNumber + "</a>";
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) {
        LOG.debug("Processing answerSplitNodeQuestion:" + routeNodeName);
        ExconProject exconProject = this.getExconProject();
        if (StringUtils.equals((CharSequence)"isActualMatch", (CharSequence)routeNodeName)) {
            if (!StringUtils.equals((CharSequence)"RPS", (CharSequence)exconProject.getProjectTypeCode())) {
                return false;
            }
            return exconProject.getRpsEntity() != null && StringUtils.equals((CharSequence)exconProject.getRpsEntity().getRpsMatchCode(), (CharSequence)"ACT");
        }
        String reviewPrefix = "requiresReviewBy";
        if (StringUtils.startsWith((CharSequence)routeNodeName, (CharSequence)reviewPrefix)) {
            String reviewTypeCode = routeNodeName.substring(reviewPrefix.length());
            for (ExconProjectReview review : exconProject.getExconProjectReviews()) {
                if (!StringUtils.equals((CharSequence)reviewTypeCode, (CharSequence)review.getProjectReviewTypeCode())) continue;
                return true;
            }
            return false;
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    public void setExconProjectService(ExconProjectService exconProjectService) {
        this.exconProjectService = exconProjectService;
    }

    public KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public DocHandlerService getDocHandlerService() {
        if (this.docHandlerService == null) {
            this.docHandlerService = KcServiceLocator.getService(DocHandlerService.class);
        }
        return this.docHandlerService;
    }

    public void setDocHandlerService(DocHandlerService docHandlerService) {
        this.docHandlerService = docHandlerService;
    }

    public KcKrmsFactBuilderServiceHelper getKcKrmsFactBuilderServiceHelper() {
        return (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("exconProjectFactBuilderService");
    }
}

