/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.util.List;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectEvent;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.rules.ExconProjectEventAddRuleImpl;

public class ExconProjectEventsBean
implements Serializable {
    private static final long serialVersionUID = 23456757457L;
    protected ExconProjectEvent newEvent;
    protected ExconProjectForm exconProjectForm;

    public ExconProjectEventsBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addExconProjectEvent() {
        boolean success = new ExconProjectEventAddRuleImpl().processAddExconProjectEventBusinessRules(this.getExconProject(), this.getExconProjectEvent());
        if (success) {
            ExconProjectEvent exconProjectEvent = this.getExconProjectEvent();
            this.getExconProject().add(exconProjectEvent);
            this.init();
        }
    }

    public void deleteExconProjectEvent(int lineToDelete) {
        this.deleteExconProjectEvent(this.getExconProjectEvents(), lineToDelete);
    }

    public ExconProjectEvent getNewEvent() {
        return this.newEvent;
    }

    public ExconProjectEvent getExconProjectEvent() {
        return this.newEvent;
    }

    public List<ExconProjectEvent> getExconProjectEvents() {
        return ((ExconProjectDocument)this.exconProjectForm.getDocument()).getExconProject().getExconProjectEvents();
    }

    public int getExconProjectEventsCount() {
        return this.getExconProjectEvents().size();
    }

    protected void deleteExconProjectEvent(List<ExconProjectEvent> events, int lineToDelete) {
        if (events.size() > lineToDelete) {
            ExconProjectEvent foundEvent = events.get(lineToDelete);
            this.getExconProject().getExconProjectEvents().remove(foundEvent);
        }
    }

    protected void init() {
        this.newEvent = new ExconProjectEvent();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }
}

