/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpression;
import org.kuali.rice.kew.rule.RuleExpressionResult;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;

class WorkflowAttributeRuleExpression
implements RuleExpression {
    WorkflowAttributeRuleExpression() {
    }

    @Override
    public RuleExpressionResult evaluate(Rule rule, RouteContext context) {
        org.kuali.rice.kew.api.rule.Rule ruleDefinition = Rule.Builder.create((RuleContract)rule.getDefinition()).build();
        boolean match = this.isMatch(ruleDefinition, context.getDocumentContent());
        if (match) {
            return new RuleExpressionResult(rule, match, ruleDefinition.getRuleResponsibilities());
        }
        return new RuleExpressionResult(rule, match);
    }

    public boolean isMatch(org.kuali.rice.kew.api.rule.Rule ruleDefinition, DocumentContent docContent) {
        if (ruleDefinition.getRuleTemplate() == null) {
            return true;
        }
        for (RuleTemplateAttribute ruleTemplateAttribute : ruleDefinition.getRuleTemplate().getActiveRuleTemplateAttributes()) {
            String attributeName = ruleTemplateAttribute.getRuleAttribute().getName();
            if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
            ExtensionDefinition extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName(attributeName);
            Object attribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
            if (attribute == null) {
                throw new RiceIllegalArgumentException("Failed to load WorkflowRuleAttribute for: " + extensionDefinition);
            }
            if (!WorkflowRuleAttribute.class.isAssignableFrom(attribute.getClass())) {
                throw new RiceIllegalArgumentException("Failed to locate a WorkflowRuleAttribute with the given name: " + attributeName);
            }
            if (attribute instanceof XmlConfiguredAttribute) {
                ((XmlConfiguredAttribute)attribute).setExtensionDefinition(extensionDefinition);
            }
            WorkflowRuleAttribute routingAttribute = (WorkflowRuleAttribute)attribute;
            ExtensionDefinition ruleAttribute = ruleTemplateAttribute.getRuleAttribute();
            if (ruleAttribute.getType().equals("RuleXmlAttribute")) {
                ((GenericXMLRuleAttribute)routingAttribute).setExtensionDefinition(ruleAttribute);
            }
            String className = ruleAttribute.getResourceDescriptor();
            ArrayList<RuleExtension> editedRuleExtensions = new ArrayList<RuleExtension>();
            for (RuleExtension extension : ruleDefinition.getRuleExtensions()) {
                if (!extension.getRuleTemplateAttribute().getRuleAttribute().getResourceDescriptor().equals(className)) continue;
                editedRuleExtensions.add(extension);
            }
            if (routingAttribute.isMatch(docContent, editedRuleExtensions)) continue;
            return false;
        }
        return true;
    }
}

