/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalDevelopmentKeyPersonsRule;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplitValidator;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class KeyPersonnelAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final Logger LOG = LogManager.getLogger(KeyPersonnelAuditRule.class);
    public static final String SPONSOR_GROUPS = "Sponsor Groups";
    private SponsorHierarchyService sponsorHierarchyService;
    private KeyPersonnelService keyPersonnelService;
    private ParameterService parameterService;

    protected SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        if (this.keyPersonnelService == null) {
            this.keyPersonnelService = KcServiceLocator.getService(KeyPersonnelService.class);
        }
        return this.keyPersonnelService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        ProposalDevelopmentDocument pd = (ProposalDevelopmentDocument)document;
        boolean retval = true;
        if (!this.hasPrincipalInvestigator(pd)) {
            retval = false;
            this.getAuditErrors("", "Error").add(new AuditError("PropDev-PersonnelPage", "error.principalInvestigators.lowbound", "PropDev-PersonnelPage"));
        }
        retval &= new ProposalDevelopmentKeyPersonsRule().processCustomSaveDocumentBusinessRules((Document)pd);
        boolean hasInvestigator = false;
        boolean hasOptInPerson = false;
        int personCount = 0;
        for (ProposalPerson person : pd.getDevelopmentProposal().getProposalPersons()) {
            retval &= this.validateInvestigator(person, personCount);
            retval = this.doPIsHaveCorrectEraCommonsNames(retval, personCount, person, pd);
            if (!hasInvestigator && this.isInvestigator(person)) {
                hasInvestigator = true;
            }
            if (BooleanUtils.isTrue((Boolean)person.getIncludeInCreditAllocation())) {
                hasOptInPerson = true;
            }
            ++personCount;
        }
        if (hasInvestigator || hasOptInPerson && this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY").booleanValue()) {
            retval &= this.validateCreditSplit((ProposalDevelopmentDocument)document);
        }
        return retval;
    }

    protected boolean doPIsHaveCorrectEraCommonsNames(boolean retval, int personCount, ProposalPerson person, ProposalDevelopmentDocument pd) {
        if (pd.getDevelopmentProposal().hasS2sOpportunity() && !pd.getDevelopmentProposal().getS2sOpportunity().getOpportunityId().isEmpty() && this.getSponsorHierarchyService().isSponsorInHierarchy(pd.getDevelopmentProposal().getSponsorCode(), SPONSOR_GROUPS, 1, "NIH") && (person.isMultiplePi() || person.isPrincipalInvestigator())) {
            retval &= this.validateEraCommonsUserName(person, personCount);
        }
        return retval;
    }

    protected boolean validateEraCommonsUserName(ProposalPerson person, int personCount) {
        boolean retval = true;
        if (person.getEraCommonsUserName() == null) {
            retval = false;
            this.getAuditErrors("Details", "Error").add(new AuditError("document.developmentProposal.proposalPersons[" + personCount + "].eraCommonsUserName", "error.investigators.eraCommonUserName", "PropDev-PersonnelPage", new String[]{person.getFullName()}));
        } else if (person.getEraCommonsUserName().length() < 6) {
            this.getAuditErrors("Details", "Warnings").add(new AuditError("document.developmentProposal.proposalPersons[" + personCount + "].eraCommonsUserName", "error.minLength", "PropDev-PersonnelPage", new String[]{"eRA Commons User Name for user " + person.getFullName() + " ", "6"}));
        }
        return retval;
    }

    protected boolean validateInvestigator(ProposalPerson person, int personCount) {
        boolean retval = true;
        if (!this.isInvestigator(person)) {
            return retval;
        }
        return retval &= this.validateInvestigatorUnits(person, personCount);
    }

    protected boolean validateInvestigatorUnits(ProposalPerson person, int personCount) {
        boolean retval = true;
        LOG.debug("validating units for " + person.getPersonId() + " " + person.getFullName());
        if (person.getUnits().size() < 1) {
            LOG.debug("error.investigatorUnits.limit");
            this.getAuditErrors("Unit Details", "Error").add(new AuditError("document.developmentProposal.proposalPersons[" + personCount + "].units", "error.investigatorUnits.upbound", "PropDev-PersonnelPage"));
        }
        for (ProposalPersonUnit unit : person.getUnits()) {
            if (StringUtils.isBlank((CharSequence)unit.getUnitNumber())) {
                LOG.trace("error.investigatorUnits.limit");
                this.getAuditErrors("Unit Details", "Error").add(new AuditError("document.developmentProposal.proposalPersons[" + personCount + "].units", "error.investigatorUnits.upbound", "PropDev-PersonnelPage"));
            }
            retval &= this.validateUnit(unit);
        }
        return retval;
    }

    private boolean validateUnit(ProposalPersonUnit source) {
        boolean retval = true;
        if (source == null) {
            LOG.debug("validated null unit");
            return false;
        }
        if (source.getUnit() == null && StringUtils.isBlank((CharSequence)source.getUnitNumber())) {
            retval = false;
        }
        if (StringUtils.isNotBlank((CharSequence)source.getUnitNumber()) && this.isInvalid(Unit.class, this.keyValue("unitNumber", source.getUnitNumber()))) {
            retval = false;
        }
        LOG.debug("Validating " + source);
        LOG.debug("validateUnit = " + retval);
        return retval;
    }

    private Map.Entry<String, String> keyValue(String key, String value) {
        return new DefaultMapEntry((Object)key, (Object)value);
    }

    private boolean isInvestigator(ProposalPerson person) {
        return person.isInvestigator();
    }

    private boolean hasPrincipalInvestigator(ProposalDevelopmentDocument document) {
        return document.getDevelopmentProposal().getPrincipalInvestigator() != null;
    }

    private List<AuditError> getAuditErrors(String sectionName, String severity) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Personnel." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, severity));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected boolean validateCreditSplit(ProposalDevelopmentDocument document) {
        boolean retval = true;
        if (this.getKeyPersonnelService().isCreditSplitEnabled()) {
            CreditSplitValidator validator = new CreditSplitValidator();
            retval &= validator.validate(document);
        }
        return retval;
    }
}

