/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.impex.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClassLoaderEntityResolver
implements EntityResolver {
    private static final Logger LOG = LogManager.getLogger(ClassLoaderEntityResolver.class);
    private static final String XML_NAMESPACE_SCHEMA = "http://www.w3.org/2001/xml.xsd";
    private static final String XSD_NAMESPACE_SCHEMA = "http://www.w3.org/2001/XMLSchema.xsd";
    private static final String XML_SCHEMA_DTD_PUBLIC_ID = "-//W3C//DTD XMLSCHEMA 200102//EN";
    private static final String DATATYPES_DTD_PUBLIC_ID = "datatypes";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private final String base;

    public ClassLoaderEntityResolver() {
        this.base = "schema";
    }

    public ClassLoaderEntityResolver(String base) {
        this.base = base;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("Resolving '" + publicId + "' / '" + systemId + "'");
        Object path = "";
        if (XML_NAMESPACE_SCHEMA.equals(systemId)) {
            path = this.base + "/xml.xsd";
        } else if (systemId.equals(XSD_NAMESPACE_SCHEMA)) {
            path = this.base + "/XMLSchema.xsd";
        } else if (XML_SCHEMA_DTD_PUBLIC_ID.equals(publicId)) {
            path = this.base + "/XMLSchema.dtd";
        } else if (DATATYPES_DTD_PUBLIC_ID.equals(publicId)) {
            path = this.base + "/datatypes.dtd";
        } else if (systemId.startsWith(CLASSPATH_PREFIX)) {
            path = systemId.substring(CLASSPATH_PREFIX.length());
            if (((String)path).startsWith("/")) {
                path = ((String)path).substring(1);
            }
        } else if (systemId.startsWith("resource")) {
            path = this.base + "/" + systemId.substring("resource:".length());
            if (!systemId.endsWith(".xsd") && !systemId.endsWith(".dtd")) {
                path = (String)path + ".xsd";
            }
        } else {
            LOG.error("Unable to resolve system id '" + systemId + "' or public id '" + publicId + "' locally...delegating to default resolution strategy.");
            return null;
        }
        InputStream is = ClassLoaderUtils.getDefaultClassLoader().getResourceAsStream((String)path);
        if (is == null) {
            String message = "Unable to find schema (" + (String)path + ") for: " + systemId;
            LOG.error(message);
            throw new SAXException(message);
        }
        return new InputSource(is);
    }
}

