/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.AwardLockService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardLockServiceImpl
extends PessimisticLockServiceImpl
implements AwardLockService {
    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((CharSequence)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "addNarratives".equals(entry.getKey()) || "modifyPermissions".equals(entry.getKey()) || "modifyProposal".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || "addBudget".equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return ObjectUtils.isNotNull((Object)fullEntryEditModeValue) && StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : editModeMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"addBudget")) continue;
            entry.setValue("FALSE");
        }
        return editModeMap;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            String lockDescriptor = document.getCustomLockDescriptor(user);
            AwardDocument awardDocument = (AwardDocument)document;
            if (StringUtils.isNotEmpty((CharSequence)lockDescriptor) && lockDescriptor.contains("BUDGET")) {
                for (AwardBudgetExt budget : awardDocument.getAward().getBudgets()) {
                    this.generateNewLock(budget.getDocumentNumber(), lockDescriptor, user);
                }
            }
            return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }
}

