/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import org.kuali.rice.core.api.util.jaxb.EnumStringAdapter;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum DataType {
    STRING(String.class, false, false),
    TIMESTAMP(Timestamp.class, false, true),
    DATE(Date.class, false, true),
    DATETIME(Date.class, false, true),
    TRUNCATED_DATE(Date.class, false, true),
    BOOLEAN(Boolean.class, false, false),
    CURRENCY(KualiDecimal.class, true, false),
    PRECISE_DECIMAL(BigDecimal.class, true, false),
    LARGE_INTEGER(BigInteger.class, true, false),
    INTEGER(Integer.class, true, false),
    LONG(Long.class, true, false),
    FLOAT(Float.class, true, false),
    DOUBLE(Double.class, true, false),
    MARKUP(String.class, false, false);

    private final Class<?> type;
    private final boolean numeric;
    private final boolean temporal;

    private DataType(Class<?> type, boolean numeric, boolean temporal) {
        this.type = type;
        this.numeric = numeric;
        this.temporal = temporal;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public static DataType getDataTypeFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (clazz == Integer.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE) {
                return INTEGER;
            }
            if (clazz == Long.TYPE) {
                return LONG;
            }
            if (clazz == Float.TYPE) {
                return FLOAT;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz == Character.TYPE) {
                return STRING;
            }
        } else {
            for (DataType dataType : DataType.values()) {
                if (!dataType.type.isAssignableFrom(clazz)) continue;
                return dataType;
            }
        }
        return null;
    }

    public static final class Adapter
    extends EnumStringAdapter<DataType> {
        @Override
        protected Class<DataType> getEnumClass() {
            return DataType.class;
        }
    }
}

