/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.questionnaire;

import java.util.Optional;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentModuleQuestionnaireBean
extends ModuleQuestionnaireBean {
    private DataObjectService dataObjectService;
    private DocumentDictionaryService documentDictionaryService;
    private DevelopmentProposal developmentProposal;

    public ProposalDevelopmentModuleQuestionnaireBean(DevelopmentProposal developmentProposal) {
        super("3", developmentProposal.getProposalNumber(), "0", "0", true);
        this.developmentProposal = developmentProposal;
        this.setFinalDoc(!this.isProposalEditable(developmentProposal));
    }

    public ProposalDevelopmentModuleQuestionnaireBean(DevelopmentProposal developmentProposal, boolean finalDoc) {
        super("3", developmentProposal.getProposalNumber(), "0", "0", true);
        this.developmentProposal = developmentProposal;
        this.setFinalDoc(finalDoc);
    }

    public ProposalDevelopmentModuleQuestionnaireBean(String moduleItemCode, String moduleItemKey, String moduleSubItemCode, String moduleSubItemKey, boolean finalDoc) {
        super(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
    }

    protected boolean isProposalEditable(DevelopmentProposal developmentProposal) {
        ProposalDevelopmentDocument doc = developmentProposal.getProposalDocument();
        return Optional.ofNullable(GlobalVariables.getUserSession()).map(UserSession::getPerson).map(user -> this.getDocumentDictionaryService().getDocumentAuthorizer((Document)doc).canEdit((Document)doc, user)).orElse(false);
    }

    @Override
    public KrmsRulesContext getKrmsRulesContextFromBean() {
        if (this.developmentProposal != null) {
            return this.developmentProposal.getKrmsRulesContext();
        }
        return this.loadKrmsRulesContext(this.getModuleItemKey());
    }

    protected KrmsRulesContext loadKrmsRulesContext(String proposalNumber) {
        DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
        return proposal.getKrmsRulesContext();
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KcServiceLocator.getService(DocumentDictionaryService.class);
        }
        return this.documentDictionaryService;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }
}

