/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class KualiInteger
extends Number
implements Comparable {
    public static final int ROUND_BEHAVIOR = 4;
    public static final int SCALE = 0;
    public static KualiInteger ZERO = new KualiInteger(0L);
    private final BigInteger value;

    public KualiInteger(String value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) String in KualiInteger constructor");
        }
        this.value = new BigInteger(value);
    }

    public KualiInteger(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public KualiInteger(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) BigDecimal in KualiDecimal constructor");
        }
        this.value = value;
    }

    public KualiInteger(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) BigDecimal in KualiDecimal constructor");
        }
        this.value = value.setScale(0, 4).toBigInteger();
    }

    public KualiInteger(KualiDecimal value, RoundingMode roundingMode) {
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) KualiDecimal in KualiInteger constructor");
        }
        if (roundingMode == null) {
            throw new IllegalArgumentException("invalid (null) RoundingMode in KualiInteger constructor");
        }
        this.value = value.bigDecimalValue().round(new MathContext(0, roundingMode)).toBigInteger();
    }

    public KualiInteger add(KualiInteger addend) {
        if (addend == null) {
            throw new IllegalArgumentException("invalid (null) addend");
        }
        BigInteger sum = this.value.add(addend.value);
        return new KualiInteger(sum);
    }

    public KualiInteger subtract(KualiInteger subtrahend) {
        if (subtrahend == null) {
            throw new IllegalArgumentException("invalid (null) subtrahend");
        }
        BigInteger difference = this.value.subtract(subtrahend.value);
        return new KualiInteger(difference);
    }

    public KualiInteger multiply(KualiInteger multiplier) {
        if (multiplier == null) {
            throw new IllegalArgumentException("invalid (null) multiplier");
        }
        BigInteger product = this.value.multiply(multiplier.value);
        return new KualiInteger(product);
    }

    public KualiInteger multiply(BigDecimal multiplier) {
        if (multiplier == null) {
            throw new IllegalArgumentException("invalid (null) multiplier");
        }
        BigDecimal product = multiplier.multiply(new BigDecimal(this.value));
        return new KualiInteger(product);
    }

    public KualiInteger multiply(KualiDecimal multiplier) {
        return this.multiply(multiplier.bigDecimalValue());
    }

    public BigDecimal divide(BigDecimal dividend) {
        if (dividend == null) {
            throw new IllegalArgumentException("invalid (null) dividend");
        }
        return this.bigDecimalValue().divide(dividend, 8, 4);
    }

    public BigDecimal divide(KualiInteger dividend) {
        if (dividend == null) {
            throw new IllegalArgumentException("invalid (null) dividend");
        }
        return this.divide(dividend.bigDecimalValue());
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public KualiDecimal kualiDecimalValue() {
        return new KualiDecimal(this.bigDecimalValue());
    }

    public boolean isLessThan(KualiInteger operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) == -1;
    }

    public boolean isGreaterThan(KualiInteger operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) == 1;
    }

    public boolean isLessEqual(KualiInteger operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isGreaterThan(operand);
    }

    public boolean isGreaterEqual(KualiInteger operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isLessThan(operand);
    }

    public boolean isNegative() {
        return this.compareTo(ZERO) == -1;
    }

    public boolean isPositive() {
        return this.compareTo(ZERO) == 1;
    }

    public boolean isZero() {
        return this.compareTo(ZERO) == 0;
    }

    public boolean isNonZero() {
        return !this.isZero();
    }

    public KualiInteger negated() {
        return this.multiply(new KualiInteger("-1"));
    }

    public int compareTo(Object o) {
        return this.compareTo((KualiInteger)o);
    }

    public int compareTo(KualiInteger k) {
        return this.value.compareTo(k.value);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof KualiInteger) {
            KualiInteger k = (KualiInteger)obj;
            equals = this.compareTo(k) == 0;
        }
        return equals;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

