/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.ScoreMode;

abstract class HitsThresholdChecker {
    HitsThresholdChecker() {
    }

    public static HitsThresholdChecker create(int totalHitsThreshold) {
        return new LocalHitsThresholdChecker(totalHitsThreshold);
    }

    public static HitsThresholdChecker createShared(int totalHitsThreshold) {
        return new GlobalHitsThresholdChecker(totalHitsThreshold);
    }

    public abstract void incrementHitCount();

    public abstract ScoreMode scoreMode();

    public abstract int getHitsThreshold();

    public abstract boolean isThresholdReached();

    private static class LocalHitsThresholdChecker
    extends HitsThresholdChecker {
        private final int totalHitsThreshold;
        private int hitCount;

        public LocalHitsThresholdChecker(int totalHitsThreshold) {
            if (totalHitsThreshold < 0) {
                throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
            }
            this.totalHitsThreshold = totalHitsThreshold;
        }

        @Override
        public void incrementHitCount() {
            ++this.hitCount;
        }

        @Override
        public boolean isThresholdReached() {
            return this.hitCount > this.totalHitsThreshold;
        }

        @Override
        public ScoreMode scoreMode() {
            return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
        }

        @Override
        public int getHitsThreshold() {
            return this.totalHitsThreshold;
        }
    }

    private static class GlobalHitsThresholdChecker
    extends HitsThresholdChecker {
        private final int totalHitsThreshold;
        private final AtomicLong globalHitCount;

        public GlobalHitsThresholdChecker(int totalHitsThreshold) {
            if (totalHitsThreshold < 0) {
                throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
            }
            this.totalHitsThreshold = totalHitsThreshold;
            this.globalHitCount = new AtomicLong();
        }

        @Override
        public void incrementHitCount() {
            this.globalHitCount.incrementAndGet();
        }

        @Override
        public boolean isThresholdReached() {
            return this.globalHitCount.get() > (long)this.totalHitsThreshold;
        }

        @Override
        public ScoreMode scoreMode() {
            return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
        }

        @Override
        public int getHitsThreshold() {
            return this.totalHitsThreshold;
        }
    }
}

