/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.IsolationFactory;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.isolation.TransactionIsolation;
import org.apache.ojb.otm.lock.map.LockMap;

public class LockManager {
    private static LockManager _Instance = new LockManager();

    public static LockManager getInstance() {
        return _Instance;
    }

    private LockManager() {
    }

    public void ensureLock(Identity identity, Transaction transaction, int n, PersistenceBroker persistenceBroker) throws LockingException {
        LockMap lockMap = transaction.getKit().getLockMap();
        ObjectLock objectLock = lockMap.getLock(identity);
        TransactionIsolation transactionIsolation = IsolationFactory.getIsolationLevel(persistenceBroker, objectLock);
        if (n == 1) {
            transactionIsolation.readLock(transaction, objectLock);
        } else if (n == 2) {
            transactionIsolation.writeLock(transaction, objectLock);
        }
    }

    public int getLockHeld(Identity identity, Transaction transaction) {
        LockMap lockMap = transaction.getKit().getLockMap();
        ObjectLock objectLock = lockMap.getLock(identity);
        int n = 0;
        if (transaction.equals(objectLock.getWriter())) {
            n = 2;
        } else if (objectLock.isReader(transaction)) {
            n = 1;
        }
        return n;
    }

    public void releaseLock(Identity identity, Transaction transaction) {
        LockMap lockMap = transaction.getKit().getLockMap();
        ObjectLock objectLock = lockMap.getLock(identity);
        objectLock.releaseLock(transaction);
    }
}

