/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.DeflateCompressor;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class CompressorFactory {
    public static final Compressor COMPRESSOR = new DeflateCompressor();

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorFactory.compressor(bytes) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        if (COMPRESSOR.isCompressed(bytes)) {
            assert (XContentHelper.xContentType(bytes) == null);
            return COMPRESSOR;
        }
        XContentType contentType = XContentHelper.xContentType(bytes);
        if (contentType == null) {
            if (CompressorFactory.isAncient(bytes)) {
                throw new IllegalStateException("unsupported compression: index was created before v2.0.0.beta1 and wasn't upgraded?");
            }
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    private static boolean isAncient(BytesReference bytes) {
        return bytes.length() >= 3 && bytes.get(0) == 90 && bytes.get(1) == 86 && (bytes.get(2) == 0 || bytes.get(2) == 1);
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(Objects.requireNonNull(bytes, "the BytesReference must not be null"));
        BytesReference uncompressed = compressor != null ? CompressorFactory.uncompress(bytes, compressor) : bytes;
        return uncompressed;
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return CompressorFactory.uncompress(bytes, compressor);
    }

    private static BytesReference uncompress(BytesReference bytes, Compressor compressor) throws IOException {
        return Streams.readFully(compressor.streamInput(bytes.streamInput()));
    }
}

