/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration.custom.coeus;

import co.kuali.coeus.data.migration.MigrationUtils;
import co.kuali.coeus.data.migration.custom.CoeusConnectionDao;
import co.kuali.coeus.data.migration.custom.RiceAwareSqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.kuali.coeus.dc.access.kim.KimAttributeDocumentValueHandler;
import org.kuali.coeus.dc.access.kim.KimTypeDao;
import org.kuali.coeus.dc.access.kim.KimTypeDaoImpl;
import org.kuali.coeus.dc.access.kim.RoleDaoImpl;
import org.kuali.coeus.dc.access.proposal.KimAttributeDefnDaoImpl;
import org.kuali.coeus.dc.access.proposal.ProposalKimAttributeDefnDao;
import org.kuali.coeus.dc.access.proposal.ProposalKimAttributeDocumentValueHandler;
import org.kuali.coeus.dc.access.proposal.ProposalRoleDaoImpl;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.SequenceDaoService;
import org.kuali.coeus.dc.common.db.SequenceDaoServiceMySqlImpl;
import org.kuali.coeus.dc.common.db.SequenceDaoServiceOracleImpl;

public class V600_085__ProposalRoleConversion
extends RiceAwareSqlExecutor {
    public void execute(Connection connection) throws SQLException {
        try (Connection riceConnection = this.riceDataSource.getConnection();){
            riceConnection.setAutoCommit(false);
            CoeusConnectionDao connDao = new CoeusConnectionDao(connection, riceConnection);
            ProposalRoleDaoImpl proposalRoleDao = new ProposalRoleDaoImpl();
            proposalRoleDao.setConnectionDaoService((ConnectionDaoService)connDao);
            Collection roleIds = proposalRoleDao.getRoleIdsToConvert();
            RoleDaoImpl roleDao = new RoleDaoImpl();
            roleDao.setConnectionDaoService((ConnectionDaoService)new CoeusConnectionDao(connection, riceConnection));
            KimTypeDaoImpl kimTypeDao = new KimTypeDaoImpl();
            kimTypeDao.setConnectionService((ConnectionDaoService)connDao);
            roleDao.setKimTypeDao((KimTypeDao)kimTypeDao);
            SequenceDaoServiceMySqlImpl sequenceDaoService = null;
            MigrationUtils.DatabaseType type = MigrationUtils.getDatabaseTypeFromConnection(connection);
            if (type == MigrationUtils.DatabaseType.Mysql) {
                sequenceDaoService = new SequenceDaoServiceMySqlImpl();
                sequenceDaoService.setConnectionDaoService((ConnectionDaoService)connDao);
            } else if (type == MigrationUtils.DatabaseType.Oracle) {
                sequenceDaoService = new SequenceDaoServiceOracleImpl();
                ((SequenceDaoServiceOracleImpl)sequenceDaoService).setConnectionDaoService((ConnectionDaoService)connDao);
            }
            roleDao.setSequenceDaoService((SequenceDaoService)sequenceDaoService);
            KimAttributeDefnDaoImpl kimAttributeDefn = new KimAttributeDefnDaoImpl();
            kimAttributeDefn.setConnectionDaoService((ConnectionDaoService)connDao);
            ProposalKimAttributeDocumentValueHandler kimDocValueHandler = new ProposalKimAttributeDocumentValueHandler();
            kimDocValueHandler.setConnectionDaoService((ConnectionDaoService)connDao);
            kimDocValueHandler.setProposalKimAttributeDefnDao((ProposalKimAttributeDefnDao)kimAttributeDefn);
            kimDocValueHandler.setDelete(true);
            roleDao.copyRoleMembersToDocAccessType(roleIds, (KimAttributeDocumentValueHandler)kimDocValueHandler);
            riceConnection.commit();
        }
    }

    public boolean executeInTransaction() {
        return true;
    }
}

