/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.lookup.valuefinder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class DocumentRouteStatusValuesFinder
extends KeyValuesBase {
    private static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        List<String> docStatusParentKeys = DocumentRouteStatusValuesFinder.asSortedList(KewApiConstants.DOCUMENT_STATUS_PARENT_TYPES.keySet());
        for (String parentKey : docStatusParentKeys) {
            ConcreteKeyValue keyLabel = new ConcreteKeyValue(parentKey, parentKey + " Statuses");
            keyValues.add((KeyValue)keyLabel);
            List docStatusCodes = (List)KewApiConstants.DOCUMENT_STATUS_PARENT_TYPES.get(parentKey);
            for (String docStatusCode : docStatusCodes) {
                ConcreteKeyValue docStat = new ConcreteKeyValue(docStatusCode, "- " + (String)KewApiConstants.DOCUMENT_STATUSES.get(docStatusCode));
                keyValues.add((KeyValue)docStat);
            }
        }
        return keyValues;
    }
}

