/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.filter.BufferedResponseWrapper13Impl;
import org.displaytag.filter.ExportDelegate;

public class ResponseOverrideFilter
implements Filter {
    private Log log;
    private boolean buffer = true;

    public void init(FilterConfig filterConfig) {
        this.log = LogFactory.getLog((Class)ResponseOverrideFilter.class);
        String bufferParam = filterConfig.getInitParameter("buffer");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("bufferParam=" + bufferParam));
        }
        this.buffer = bufferParam == null || StringUtils.equalsIgnoreCase((String)"true", (String)bufferParam);
        this.log.info((Object)("Filter initialized. Response buffering is " + (this.buffer ? "enabled" : "disabled")));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getParameter("6578706f7274") == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Messages.getString("ResponseOverrideFilter.parameternotfound"));
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        BufferedResponseWrapper13Impl wrapper = new BufferedResponseWrapper13Impl((HttpServletResponse)servletResponse);
        HashMap<String, Boolean> contentBean = new HashMap<String, Boolean>(4);
        if (this.buffer) {
            contentBean.put("buffer", Boolean.TRUE);
        }
        request.setAttribute("org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY", contentBean);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        ExportDelegate.writeExport((HttpServletResponse)servletResponse, servletRequest, wrapper);
    }

    public void destroy() {
    }
}

