/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.listener;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionLoggingListener
implements HttpSessionListener {
    private static final Logger LOG = LogManager.getLogger(SessionLoggingListener.class);

    public void sessionCreated(HttpSessionEvent se) {
        if (this.isLoggingAllowed()) {
            this.logSessionStart(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.isLoggingAllowed()) {
            this.logSessionEnd(se);
        }
    }

    protected void logSessionEnd(HttpSessionEvent event) {
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long originalMemory = (Long)event.getSession().getAttribute("startingMemory");
        Object difference = "";
        difference = originalMemory < usedMemory ? "Memory usage increased by " + (usedMemory - originalMemory) : "Memory usage decreased by " + (originalMemory - usedMemory);
        LOG.info("Session was just destroyed : " + usedMemory + " memory used. Originally created with " + originalMemory + " memory used. " + (String)difference);
    }

    protected void logSessionStart(HttpSessionEvent event) {
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        event.getSession().setAttribute("startingMemory", (Object)usedMemory);
        LOG.info("Session was just created : " + usedMemory + " memory used");
    }

    protected boolean isLoggingAllowed() {
        return LOG.isInfoEnabled();
    }
}

