/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.util.stream.Collectors;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;

class SponsorDataFeedCommand
extends ProposalDataFeedCommandBase {
    public SponsorDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType == FundingProposalMergeType.NEWAWARD && this.award.getSponsorCode() == null) {
            this.award.setSponsor(this.proposal.getSponsor());
            this.award.setSponsorCode(this.proposal.getSponsorCode());
        }
        if (this.mergeType == FundingProposalMergeType.NEWAWARD || this.mergeType == FundingProposalMergeType.REPLACE) {
            if (this.award.getPrimeSponsorCode() == null || this.mergeType == FundingProposalMergeType.REPLACE) {
                this.award.setPrimeSponsor(this.proposal.getPrimeSponsor());
                this.award.setPrimeSponsorCode(this.proposal.getPrimeSponsorCode());
            }
            this.award.setAwardCfdas(this.proposal.getProposalCfdas().stream().map(cfda -> {
                AwardCfda awardCfda = new AwardCfda();
                awardCfda.setCfdaNumber(cfda.getCfdaNumber());
                awardCfda.setCfdaDescription(cfda.getCfdaDescription());
                awardCfda.setAwardId(this.award.getAwardId());
                awardCfda.setAwardNumber(this.award.getAwardNumber());
                awardCfda.setSequenceNumber(this.award.getSequenceNumber());
                awardCfda.setAward(this.award);
                return awardCfda;
            }).collect(Collectors.toList()));
            this.award.setNsfSequenceNumber(this.proposal.getNsfSequenceNumber());
        }
    }
}

